#ifndef PLACESLISTMODEL_H
#define PLACESLISTMODEL_H

#include <QAbstractListModel>
#include <QList>
#include "facebookgraph/place.h"

class PlacesListModel : public QAbstractListModel
{
    Q_OBJECT
public:
    enum PlacesRoles {
        PlaceNumberRole = Qt::UserRole + 1,
        PlaceNameRole,
        PlaceAddressRole
    };

    explicit PlacesListModel(QObject *parent = 0);

    void addPlace(QString placeNumber, QString placeName, QString placeAddress);
    void addPlace(Place *place);
    void addPlaces(QList<Place*> places);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    void clear();

signals:

public slots:

private:
    QList<Place*> m_places;
};

#endif // PLACESLISTMODEL_H
