#include "placeslistmodel.h"
#include <QDebug>
#include <QHash>

PlacesListModel::PlacesListModel(QObject *parent) :
    QAbstractListModel(parent)
{
    QHash<int,QByteArray> roles;
    roles[PlaceNumberRole] = "placeId";
    roles[PlaceNameRole] = "placeName";
    roles[PlaceAddressRole] = "placeAddress";
    setRoleNames(roles);
}

void PlacesListModel::addPlace(QString placeNumber, QString placeName, QString placeAddress)
{
    Place *place = new Place(this);
    place->setId(placeNumber);
    place->setName(placeName);
    place->setAddress(placeAddress);
    addPlace(place);
}

void PlacesListModel::addPlace(Place *place)
{
    if (place==NULL) return;
    beginInsertRows(QModelIndex(),m_places.size(),m_places.size());
    m_places.append(place);;
    endInsertRows();
}

void PlacesListModel::addPlaces(QList<Place *> places)
{
    if (places.isEmpty()) return;
    int begin = m_places.size();
    int end = begin + places.size() - 1;
    beginInsertRows(QModelIndex(),begin,end);
    for (int index=0;index<places.size();index++) {
        Place *place = new Place(places[index]);
        //qDebug()<<"adding place to model:"<<place->toString();
        m_places.append(place);
    }
    endInsertRows();
}

int PlacesListModel::rowCount(const QModelIndex &parent) const
{
    return m_places.size();
}

QVariant PlacesListModel::data(const QModelIndex &index, int role) const
{
    if (index.row()<0 || index.row()>=m_places.size()) return QVariant();
    Place *place = m_places[index.row()];
    switch(role)
    {
    case PlaceNumberRole:
        return place->getId();
    case PlaceNameRole:
        return place->getName();
    case PlaceAddressRole:
        if (place->getAddress().isEmpty()) return tr("unknown");
        return place->getAddress();
    default:
        return QVariant();
    }
}

void PlacesListModel::clear()
{
    if (m_places.isEmpty()) return;
    beginRemoveRows(QModelIndex(),0,m_places.size()-1);
    m_places.clear();
    endRemoveRows();
}
