/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <QtGui/QApplication>
#include <QGraphicsObject>
#include <QtDeclarative/QDeclarativeView>
#include <QUrl>
#include "fbactions.h"
#include "browserlauncher.h"
#include "geography.h"
#include "uihelper.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    FbActions fb_actions;
    BrowserLauncher browser_launcher;
    Geography geography;

    UiHelper uiHelper;

    QObject::connect(&uiHelper,SIGNAL(facebookClicked()),&browser_launcher,SLOT(launch_facebook()));

    QObject::connect(&uiHelper,SIGNAL(refreshClicked()),&fb_actions,SLOT(request_status()));
    QObject::connect(&uiHelper,SIGNAL(submitClicked(QString)),&fb_actions,SLOT(set_status(QString)));
    QObject::connect(&uiHelper,SIGNAL(configClicked()),&fb_actions,SLOT(do_configuration()));
    QObject::connect(&uiHelper,SIGNAL(submitCheckinClicked(QString,QString,qreal,qreal)),&fb_actions,SLOT(do_checkin(QString,QString,qreal,qreal)));
    QObject::connect(&uiHelper,SIGNAL(needPlaces(qreal,qreal)),&fb_actions,SLOT(request_places_nearby(qreal,qreal)));
    QObject::connect(&fb_actions,SIGNAL(status_available(QString)),&uiHelper,SLOT(setOldStatus(QString)));
    QObject::connect(&fb_actions,SIGNAL(status_successfully_set()),&uiHelper,SLOT(clearStatusBox()));
    QObject::connect(&fb_actions,SIGNAL(places_nearby(QList<Place*>)),&uiHelper,SLOT(setPlacesNearby(QList<Place*>)));

    QObject::connect(&uiHelper,SIGNAL(needLocation()),&geography,SLOT(request_current_location()));
    QObject::connect(&uiHelper,SIGNAL(dontNeedLocation()),&geography,SLOT(stop_gps()));
    QObject::connect(&geography,SIGNAL(gps_status(int)),&uiHelper,SLOT(setGpsStatus(int)));
    QObject::connect(&geography,SIGNAL(obtained_location(qreal,qreal)),&uiHelper,SLOT(setLocation(qreal,qreal)));

#if defined(Q_WS_MAEMO_5)
    uiHelper.setGeometry(QRect(0,0,800,425)); //This is Maemo with menu showing
    uiHelper.show();
#elif defined(Q_WS_S60)
    uiHelper.setGeometry(QRect(0,0,640,360));
    uiHelper.showMaximized();
#else
    uiHelper.setGeometry(QRect(100,100,800, 480));
    uiHelper.show();
#endif
    fb_actions.request_status();
    return a.exec();
}
