#include "geography.h"
#include <QDebug>

Geography::Geography(QObject *parent) :
    QObject(parent)
{
    current_status = GPS_STATUS_READY;
    satellite_count = 0;
}

//Slots

void Geography::request_current_location()
{
    request_location();
}

void Geography::request_gps_status()
{
    emit gps_status(current_status);
}

void Geography::stop_gps()
{
    qDebug()<<"Handling stop_gps signal";
    if (location_data_source)
        location_data_source->stopUpdates();
//    if (satellite_info_source)
//        satellite_info_source->stopUpdates();
}

//private slots
void Geography::positionUpdated(QGeoPositionInfo geoPositionInfo)
{
    if (geoPositionInfo.isValid()) {
        QGeoCoordinate coordinate = geoPositionInfo.coordinate();
        if (coordinate.isValid()) {
            emit obtained_location(coordinate.latitude(),coordinate.longitude());
//            qDebug()<<QString("Obtained longitude %1 and latitude %2 (Satellites: %3)").
//                    arg(coordinate.longitude()).arg(coordinate.latitude()).arg(satellite_count);
           //Perhaps this status should be dependent on the number of satellites?
            update_status(GPS_STATUS_SUCCESS);
        } else {
            update_status(GPS_STATUS_ERROR);
        }
    } else {
        update_status(GPS_STATUS_ERROR);
    }
}

//void Geography::satellitesInUseUpdated(QList<QGeoSatelliteInfo> &satellites)
//{
//    satellite_count = satellites.size();
//    qDebug()<<"Satellite count is now "<<satellite_count;
//    QGeoSatelliteInfo sat;
//    foreach (sat,satellites)
//    {
//        qDebug()<<"Sat signal strength:"<<sat.signalStrength();
//    }
//}

// private

void Geography::request_location()
{
    if (!location_data_source)
    {
        location_data_source = QGeoPositionInfoSource::createDefaultSource(this);
        if (location_data_source) {
            QObject::connect(location_data_source,SIGNAL(positionUpdated(QGeoPositionInfo)),this,SLOT(positionUpdated(QGeoPositionInfo)));
        } else {
            qWarning()<<"No location data source found - GPS info not available";
            current_status = GPS_STATUS_UNAVAILABLE;
        }
    }

//    if (!satellite_info_source)
//    {
//        satellite_info_source = QGeoSatelliteInfoSource::createDefaultSource(this);
//        if (satellite_info_source) {
//            bool connected = QObject::connect(satellite_info_source,SIGNAL(satellitesInUseUpdated(QList<QGeoSatelliteInfo>&)),this,SLOT(satellitesInUseUpdated(QList<QGeoSatelliteInfo>&)));
//            if (!connected) {
//                qDebug()<<"Unable to connect to satellites in use updated signal...deleting satellite_info_source";
//                delete(satellite_info_source);
//                satellite_info_source = NULL;
//            }
//        }
//    }

    if (location_data_source)
    {
        update_status(GPS_STATUS_SEARCHING);
        location_data_source->startUpdates();
    }
    else update_status(GPS_STATUS_UNAVAILABLE);

//    if (satellite_info_source) {
//        satellite_info_source->startUpdates();
//    }
}

void Geography::update_status(int status)
{
    current_status = status;
    emit gps_status(status);
}

