#include "placelist.h"
#include <QScriptEngine>
#include <QLatin1String>
#include <QDebug>

const QLatin1String PlaceList::OPEN_PAREN("(");
const QLatin1String PlaceList::CLOSE_PAREN(")");


PlaceList::PlaceList(QObject *parent) :
    QObject(parent)
{
}

void PlaceList::addPlace(Place *place)
{
    _list.append(place);
}

QList<Place*> PlaceList::getList()
{
    return _list;
}

void PlaceList::parseFbResults(QByteArray bytes) {
    //format is data contains array of objects
    //each datum is name-string, category-string, id-int >64 bits, and location
    //location contains: street, city, state, country, zip, latitude, longitude

    qDebug() << "Beginning PlaceList::parseFbResults()";
    if (bytes.isEmpty()){
        qWarning() << "JSON was empty";
        return;
    }

    QScriptEngine script_engine;
    QScriptValue script_value = script_engine.evaluate(OPEN_PAREN + bytes + CLOSE_PAREN);
    if (script_value.isError())
    {
        qCritical() << "Unable to parse JSON: " << bytes;
        return;
    }

    if (script_value.property("data").isValid()) {
        qDebug() << "Found data node";
        QScriptValue data = script_value.property("data");
        if (data.isArray()) {
            int arrayCount = data.property("length").toInt32();
            for (int index=0; index<arrayCount; index++)
            {
                //qDebug() << "Processing data index #" << index;
                QScriptValue data_entry = data.property(QString("%1").arg(index));
                if (data_entry.isValid())
                    _list.append(parseDataEntry(data_entry));
            }
        }

    }

}

Place* PlaceList::parseDataEntry(QScriptValue data_entry)
{
    Place* place = new Place();
    if (data_entry.isValid()) {
        if (data_entry.property("name").isValid()) place->setName(data_entry.property("name").toString());
        if (data_entry.property("id").isValid()) place->setId(data_entry.property("id").toString());
        QScriptValue location = data_entry.property("location");
        if (location.isValid()) {
            QScriptValue street = location.property("street");
            if (street.isValid()) place->setAddress(street.toString());
        }
    }
//    qDebug()<<"Found place:"<<place->toString();
    return place;
}

QString PlaceList::toString()
{
    QString output("PlaceList: ");
    for (int i=0; i<_list.count(); i++)
    {
        output+= _list[i]->toString();
    }
    return output;
}
