#ifndef PLACE_H
#define PLACE_H

#include <QObject>

class Place : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString id READ getId WRITE setId)
    Q_PROPERTY(QString name READ getName WRITE setName)
    Q_PROPERTY(QString address READ getAddress WRITE setAddress)

public:
    explicit Place(QObject *parent = 0);
    Place(const Place &other);
    Place(const Place *other);


    QString getId() {return _id;}
    void setId(QString id) {_id = id;}
    QString getName() {return _name;}
    void setName(QString name) {_name = name;}
    QString getAddress() {return _address;}
    void setAddress(QString address) {_address = address;}

    QString toString() {return QString("[id: %1  name: %2  address: %3]").arg(_id).arg(_name).arg(_address);}

signals:

public slots:

private:
    QString _id; //the ids can be more than 64 bit integers.  So keep it as a string.
    QString _name;
    QString _address;
};

#endif // PLACE_H
