/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef FBACTIONS_H
#define FBACTIONS_H

#include <QObject>
#include <QByteArray>
#include <QDateTime>
#include <QList>
#include <QMultiMap>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QtScript/QScriptValue>
#include "settingsmanager.h"

class FbActions : public QObject
{
    Q_OBJECT
public:
    explicit FbActions(QObject *parent = 0);
    bool is_need_auth_token();
    void set_token(QString token);

signals:
    void status_available(QVariant status);
    void status_successfully_set();

public slots:
    void request_status();
    void unauthorize();
    void set_status(QString status);
    void do_configuration();
    void do_not_implemented();

private:
    QString get_auth_token();
    QNetworkAccessManager access_manager;
    SettingsManager settings_manager;
    void emit_simple_message(QString text);
    QDateTime parseTime(QScriptValue jsonNode);

    QList<QNetworkReply*> status_replies;
    QList<QNetworkReply*> set_status_replies;
    void handle_status_response(QByteArray bytes);
    void handle_set_status_response(QByteArray bytes);

private slots:
    void handle_http_response(QNetworkReply* reply);
};

#endif // FBACTIONS_H
