 import Qt 4.7

Rectangle {id: main



    width: 800; height: 425;
    color: "gray";

    signal refreshClicked;
    signal facebookClicked;
    signal mysteryClicked;
    signal submitClicked(string statusText);
    signal configClicked();

    function setOldStatus(oldStatusText) {
        currentStatus.text = oldStatusText;
    }

    function clearStatusBox() {
        newStatus.text = "";
    }

    Row {id: mainRow;
        width: main.width;
        height: main.height;
        Column {id: textsColumn;
            width: parent.width - buttonsColumn.width;
            height: parent.height;
            Rectangle {id: currentStatusMain
                height: parent.height - newStatusRectangle.height;
                width: parent.width;
                gradient: Gradient {
                     GradientStop { position: 0.0; color: "gray" }
                     GradientStop { position: 1.0; color: "black" }
                }

                Text {id: watermark;
                    anchors.horizontalCenter: parent.horizontalCenter;
                    anchors.verticalCenter: parent.verticalCenter;
                    text:"old status";
                    font.family: "Arial, Helvetica, Sans-Serif";
                    color:"black";
                    font.pixelSize: main.height/4
                    font.weight: Font.Black;
                    opacity: 0.5;
                }

                SequentialAnimation {
                    id: watermark_animation;
                    NumberAnimation {
                        target: watermark; properties: "opacity";
                        from: 0.1; to: 0.5; duration: 7500;
                        easing.type: "OutExpo";
                    }
                    NumberAnimation {
                        target: watermark; properties: "opacity";
                        from: 0.5; to: 0.1; duration: 7500;
                        easing.type: "OutExpo";
                    }
                    loops: Animation.Infinite

                    running:true;
                }

                Flickable {id: currentStatusFlick
                    clip:true;
                    contentHeight: currentStatus.height;
                    anchors.fill: currentStatusMain;
                    Text { id: currentStatus;
                        width: parent.width;
                        text: "<p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p><p><b>Section: </b> This is some info <i>(5/5/05)</i><ul><li>item one</li><li>item two</li></ul></p>";
                        font.family: "Arial, Helvetica, Sans-Serif";
                        color: "white";
                        wrapMode: Text.Wrap;
                        }
                }
            }
            Rectangle { id:newStatusRectangle;
                height: submitButton.height;  //try to get the bottom elements to line up
                width: textsColumn.width;
                border.width:1;
                border.color:"gray";
                opacity: 1;
                color: "black"
                    Text {id: status_instructions;
                        anchors.horizontalCenter: newStatusRectangle.horizontalCenter;
                        anchors.verticalCenter: newStatusRectangle.verticalCenter;
                        text:"new status";
                        font.family: "Arial, Helvetica, Sans-Serif";
                        color:"gray";
                        font.pixelSize: newStatusRectangle.height/2;
                        font.weight: Font.Black;
                        opacity: 0.5;
                    }//Text

                    SequentialAnimation {
                        id: status_instructions_animation;
                        NumberAnimation {
                            target: status_instructions; properties: "opacity";
                            from: 0.5; to: 0.1; duration: 7500;
                            easing.type: "OutExpo";
                        }
                        NumberAnimation {
                            target: status_instructions; properties: "opacity";
                            from: 0.1; to: 0.5; duration: 7500;
                            easing.type: "OutExpo";
                        }
                        loops: Animation.Infinite

                        running:true;
                    } //SequentialAnimation

                Flickable {id : newStatusFlick;
                    anchors.fill: newStatusRectangle;
                    contentWidth: newStatus.paintedWidth;
                    contentHeight: newStatus.paintedHeight;
                    clip: true;

                    function ensureVisible(r) {
                        if (contentX >= r.x)
                            contentX = r.x
                        else if (contentX+width <= r.x+r.width)
                            contentX = r.x+r.width-width;
                        if (contentY >= r.y)
                            contentY = r.y;
                        else if (contentY+height <= r.y+r.height)
                            contentY = r.y+r.height-height;
                    } //function

                    TextEdit { id: newStatus;
                        width: newStatusFlick.width;
                        height: newStatusFlick.height;
                        text: "";
                        color: "white";
                        font.family: "Arial, Helvetica, Sans-Serif";
                        wrapMode: Text.Wrap;
                        onCursorRectangleChanged: newStatusFlick.ensureVisible(cursorRectangle);
                        clip: true;
                    } // Textedit
                } //Flickable
            }//Rectangle
        }
        Column {id: buttonsColumn;
            height: mainRow.height;
            width: mainRow.height / 5;
            BlackButton{id:refreshButton;
                label:"";
                image_source: "refresh.png";
                width: buttonsColumn.width;
                height: buttonsColumn.height/5;
                onBlackButtonClicked: refreshClicked();
            }
            BlackButton{id:facebookButton;
                label:"";
                image_source: "eff.png";
                width: buttonsColumn.width;
                height: buttonsColumn.height/5;
                onBlackButtonClicked: facebookClicked();
            }
            BlackButton{id:buttonConfig;
                label:"";
                image_source: "gear.png"
                width: buttonsColumn.width;
                height: buttonsColumn.height - refreshButton.height - facebookButton.height - mysteryButton.height - submitButton.height;
                onBlackButtonClicked: configClicked();
            }
            BlackButton{id:mysteryButton;
                label:"???";
                width: buttonsColumn.width;
                height: buttonsColumn.height/5;
                onBlackButtonClicked: mysteryClicked();
            }
            BlackButton{id:submitButton;
                label:"";
                image_source: "transmit.png";
                width: buttonsColumn.width;
                height: buttonsColumn.height/5;
                onBlackButtonClicked: submitClicked(newStatus.text);
            }
        }
    } // Row
} // Rectangle main
