/* This file is part of effing
 *
 * Copyright (C) 2010 Richard Merren <richard@merren.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CONSTANTS_H
#define CONSTANTS_H

#include <QString>
#include <QUrl>

const QString PROGRAM_NAME = "Effing";
const QString COMPANY_NAME = "Merren Technology LLC";
const QString FB_GROUP = "FB_Settings";
const QString PROP_AUTH_KEY_OLD = "auth_key";
const QString PROP_AUTH_KEY_EFFING = "auth_key_effing";
const QString PROP_AUTH_KEY_G_RATED = "auth_key_g_rated";
const QString PROP_PREFER_TOUCH = "prefer_facebook_touch";
const QString PROP_TAG_LINE_PREF = "prefer_g_rated_tag_line";
const QString PROP_SHOW_INITIAL_CONFIG = "show_config_on_startup";


const QString FACEBOOK_APP_ID = "110268628995772";
const QString FACEBOOK_APP_ID_G_RATED = "130026103718023";
const QString AUTH_HOST = "graph.facebook.com";
const QString AUTH_PATH = "/oauth/authorize";
const QString AUTH_REDIRECT_URI ="http://www.facebook.com/connect/login_success.html";
const QString AUTH_KEY_NAME = "access_token";
const QString AUTH_REGEX_TEXT = QString("%1#%2=([^&]+)").arg(AUTH_REDIRECT_URI,AUTH_KEY_NAME);

const QUrl FACEBOOK_FULL_URL = QUrl("http://www.facebook.com");
const QUrl FACEBOOK_TOUCH_URL = QUrl("http://touch.facebook.com");

const int MAX_STATUS_LENGTH = 420;

#endif // CONSTANTS_H
