/*
 * This file is part of edicom application
 *
 * Copyright (C) 2010 Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * Contact: Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include <QDialog>

class GoogleDocumentService;
class ShareProgramDialog;

namespace Ui {
    class LoginDialog;
}

class LoginDialog : public QDialog
{
    Q_OBJECT

public:
    explicit LoginDialog(QWidget *parent = 0);
    ~LoginDialog();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::LoginDialog *ui;
private slots:
    void signInButtonClicked();
    void authenticated(bool);
public:
    GoogleDocumentService *googleDoc;
    ShareProgramDialog *shareProgramDialog;
};

#endif // LOGINDIALOG_H
