/*
 * This file is part of edicom application
 *
 * Copyright (C) 2010 Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * Contact: Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include "scannerthread.h"
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <QInputDialog>
#include <QMutex>
#include <QFile>
#include <QTextStream>
//#include <QDebug>
#include <QMessageBox>
#include <QFileDialog>

ScannerThread::ScannerThread(QObject *parent)
    : QThread(parent)
{
    this->stopFlag=false;
    m_bToSuspend=false;
}
void ScannerThread::run()
{
    QMutex waitMutex;
    sleep(2);
        while(stopFlag==false)
        {
            QFile pidFile("/tmp/pid.ec");
            QString pid;
            if(pidFile.exists())
            {
                if (pidFile.open(QFile::ReadOnly))
                {
                    QTextStream out(&pidFile);
                    pid=out.readAll();
                }
                //qDebug()<<pid;
                pidFile.close();
                //pid.trimmed();
                QFile status("/proc/"+pid+"/status");
                if(status.exists())
                {
                    if (status.open(QFile::ReadOnly))
                    {
                        QTextStream out(&status);
                        QString buffer=out.readAll();
                        QStringList afterSplit=buffer.split("\n");
                        //qDebug()<<afterSplit[1];
                        if(afterSplit[1].contains("sleeping"))
                        {
                            emit showScanDialog();
                            //system("scanf");
                        }
                    }
                }
                else
                {
                    //qDebug()<<pid<<"\nnot found";
                    //QMessageBox::warning(this, tr("Application"),tr("check program pid not found"));
                }
            }

             if (m_bToSuspend)
             {
                m_waitCondt.wait(&waitMutex);
             }
        }
}
void ScannerThread::suspend()
{
    m_bToSuspend = true;
}

void ScannerThread::resume()
{
    if (!m_bToSuspend)
        return;

    m_bToSuspend = false;
    m_waitCondt.wakeOne();
}
