/*
 * Dstroy, a remake of the bomberman-like DOS game from Fully Bugged Software
 * Copyright (C) Michael Doguet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#include "stdafx.h"
#include "TGIGlobals.h"

#include <iostream>
#include <string>

#include "TGIMain.h"

#ifdef __NDS__
#include <nds.h>
#include <nds/arm9/console.h>
#include <fat.h>  
#include <stdio.h>
#define		VCOUNT		(*((u16 volatile *) 0x04000006))

inline void WaitForVblank() {
			while(VCOUNT>192); // wait for vblank
			while(VCOUNT<192);
}

#endif


TGIMain* TGIGlobals::theMain = NULL;
SDL_Surface* TGIGlobals::pScreen = NULL;
TGIint TGIGlobals::screenWidth = 0;
TGIint TGIGlobals::screenHeight = 0;
bool TGIGlobals::bRotateScreen = false;
//#ifndef __NDS__
Mix_Music* TGIGlobals::pMusic = NULL;
TGIuint16 TGIGlobals::nRepeat = 0;
TGIuint16 TGIGlobals::nRepeatPos = 0;
//#else
//int TGIGlobals::nMusicRes = -1;
//#endif //__NDS__
std::vector<SDL_Joystick*> TGIGlobals::vecJoystick;
TGIuint8 TGIGlobals::nSpriteSize = 1;

TGIGlobals::TGIGlobals(void)
{
}

TGIGlobals::~TGIGlobals(void)
{
}

void TGIGlobals::Trace(std::string strMessage, ...)
{
	//a refaire
#ifdef _TGI_DEBUG
	printf("%s\n",strMessage.c_str());
#endif
}

bool TGIGlobals::init(TGIint screenWidth, TGIint screenHeight, TGIuint8 nSpriteSize, bool bFullScreen, bool bRotateScreen)
{
 	TGIGlobals::nSpriteSize = nSpriteSize;
	TGIGlobals::bRotateScreen = bRotateScreen;

	TGIGlobals::screenWidth = screenWidth;
	TGIGlobals::screenHeight = screenHeight;



	//SDL init
	TGIint err  = 0;
	err = SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK);

	if (err < 0)
	{ 
		TGIGlobals::Trace("Cant initiate SDL: %s\n", SDL_GetError()); 
		return false;
	}
	TGIGlobals::Trace("SDL initiated");

	//const SDL_VideoInfo *info = SDL_GetVideoInfo();

	//toute la SDL

	SDL_ShowCursor(0);
	if (bFullScreen)
	{
		TGIGlobals::pScreen = SDL_SetVideoMode(TGIGlobals::screenWidth*nSpriteSize, TGIGlobals::screenHeight*nSpriteSize, 16, SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN|SDL_ASYNCBLIT);
	}
	else
	{
		TGIGlobals::pScreen = SDL_SetVideoMode(TGIGlobals::screenWidth*nSpriteSize, TGIGlobals::screenHeight*nSpriteSize, 16, SDL_HWSURFACE|SDL_DOUBLEBUF);
	}
	if (pScreen == NULL)
	{
		TGIGlobals::Trace("Error while initializing screen\n");
		return false;
	}
	//joysticks
	int nJoys = SDL_NumJoysticks() - 1;
	SDL_Joystick* pJoy;
	for (;nJoys>=0;nJoys--)
	{
		pJoy = SDL_JoystickOpen(nJoys);
		if (pJoy)
		{
			vecJoystick.push_back(pJoy);
		}
	}
	//sound
	SDL_InitSubSystem(SDL_INIT_AUDIO);
	int n;
	n = Mix_OpenAudio(22050, AUDIO_S16, 2, 2048);
	Mix_HookMusicFinished(music_finished);


	return true;
}

bool TGIGlobals::exit(void)
{
	Mix_CloseAudio();
	SDL_QuitSubSystem(SDL_INIT_AUDIO);

	
	for (TGIuint16 i=0;i<vecJoystick.size();i++)
	{
		SDL_JoystickClose(vecJoystick[i]);
	}

	SDL_Quit();

	return true;
}


void TGIGlobals::endianConvert(TGIuint16 order, void* pData, TGIuint16 nLen)
{
	if (order == 255)
	{
		//no need to convert
		return;
	}

	TGIint i;
	TGIuint8 t;
	for (i=nLen/2-1;i>=0;i--)
	{
		t = ((TGIuint8*)pData)[i];
		((TGIuint8*)pData)[i] = ((TGIuint8*)pData)[nLen-i-1];
		((TGIuint8*)pData)[nLen-i-1] = t;
	}
}


bool TGIGlobals::playMusic(std::string cstrFile, TGIuint16 nRepeat, TGIuint16 nRepeatPos)
{
	char strDebug[256];
	sprintf(strDebug, "playMusic:%s", cstrFile.c_str());
	TGIGlobals::Trace(strDebug);
	TGIGlobals::stopMusic();

	TGIGlobals::pMusic = Mix_LoadMUS(cstrFile.c_str());
	if (!TGIGlobals::pMusic)
		return false;
	TGIGlobals::nRepeatPos = nRepeatPos;
	TGIGlobals::nRepeat = nRepeat - 1;

	return Mix_PlayMusic(TGIGlobals::pMusic, 1) == 0;
	return false;
}

bool TGIGlobals::stopMusic(void)
{
	if (TGIGlobals::pMusic)
	{
		Mix_HaltMusic();
		Mix_FreeMusic(TGIGlobals::pMusic);
		TGIGlobals::pMusic = NULL;
	}
	return true;
}

void TGIGlobals::music_finished()
{

	if (nRepeat == 0)
		return;
	if (nRepeat > 0)
		nRepeat--;

	
	Mix_PlayMusic(TGIGlobals::pMusic, 1);
	Mix_PauseMusic();
	Mix_SetMusicPosition(nRepeatPos);
	Mix_ResumeMusic();

}

