/*
 * Dstroy, a remake of the bomberman-like DOS game from Fully Bugged Software
 * Copyright (C) Michael Doguet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include "DstroyMenuCommandConfig.h"
#include "DstroyMenuOptions.h"

#include "DstroyGlobals.h"

DstroyMenuCommandConfig::DstroyMenuCommandConfig(TGIuint16 lIdRecipient)
{
	this->lIdRecipient = lIdRecipient;
}

DstroyMenuCommandConfig::~DstroyMenuCommandConfig(void)
{
}

bool DstroyMenuCommandConfig::init(void)
{
	if (!DstroyMenu::init())
		return false;


	return true;
}

bool DstroyMenuCommandConfig::events(void)
{
	if (!loadCommands(DstroyGlobals::addConfigText("commands")))
	{
		loadCommands(DstroyGlobals::addResText("commands"));
	}

	TGIint nPos = 40;
	for (TGIuint16 i=0;i<vecInputMessage.size();i++)
	{
		if (vecInputMessage[i].lIdRecipient == lIdRecipient)
		{

			if ( lIdRecipient == 1 )
			{
				char* mensaje;
				if (i==0) mensaje = "PLAYER1 LEFT";
				if (i==1) mensaje = "PLAYER1 RIGHT";
				if (i==2) mensaje = "PLAYER1 UP";
				if (i==3) mensaje = "PLAYER1 DOWN";
				if (i==4) mensaje = "PLAYER1 FIRE";
				writeText(mensaje, TGIGlobals::screenWidth/2, nPos, TAcenter);
			}
			else 
			{
				char* mensaje;
				if (i==0) mensaje = "LEFT";
				if (i==1) mensaje = "RIGHT";
				if (i==2) mensaje = "UP";
				if (i==3) mensaje = "DOWN";
				if (i==4) mensaje = "FIRE";
				writeText(mensaje, TGIGlobals::screenWidth/2, nPos, TAcenter);
			}
			/*else
			{
				writeText(vecInputMessage[i].strName, TGIGlobals::screenWidth/2, nPos, TAcenter);
			}*/
			draw();
			vecInputMessage[i].autoFill();
			nPos += 20;
		}
	}

	saveCommands(DstroyGlobals::addConfigText("commands"));

	stop();
	DstroyMenuOptions* pMenu = new DstroyMenuOptions;

	return false;
}
