/*
 * Dstroy, a remake of the bomberman-like DOS game from Fully Bugged Software
 * Copyright (C) Michael Doguet
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */


#include "stdafx.h"
#include "TGIGlobals.h"

#include <iostream>
#include <string>

#include "TGIMain.h"

#ifdef __NDS__
#include <nds.h>
#include <nds/arm9/console.h>
#include <fat.h>  
#include <stdio.h>
#define		VCOUNT		(*((u16 volatile *) 0x04000006))

inline void WaitForVblank() {
			while(VCOUNT>192); // wait for vblank
			while(VCOUNT<192);
}

#endif


TGIMain* TGIGlobals::theMain = NULL;
SDL_Surface* TGIGlobals::pScreen = NULL;
TGIint TGIGlobals::screenWidth = 0;
TGIint TGIGlobals::screenHeight = 0;
bool TGIGlobals::bRotateScreen = false;
#ifndef TGI_NOSOUND
#ifndef __NDS__
Mix_Music* TGIGlobals::pMusic = NULL;
TGIuint16 TGIGlobals::nRepeat = 0;
TGIuint16 TGIGlobals::nRepeatPos = 0;
#else
int TGIGlobals::nMusicRes = -1;
#endif //__NDS__
#endif
std::vector<SDL_Joystick*> TGIGlobals::vecJoystick;
TGIuint8 TGIGlobals::nSpriteSize = 1;
#ifdef GP2X
TGIuint8 TGIGlobals::nGP2XmvtMode = 1;
#endif

TGIGlobals::TGIGlobals(void)
{
}

TGIGlobals::~TGIGlobals(void)
{
}

void TGIGlobals::Trace(std::string strMessage, ...)
{
	//a refaire
#ifdef _TGI_DEBUG
	printf("%s\n",strMessage.c_str());
#endif
}

bool TGIGlobals::init(TGIint screenWidth, TGIint screenHeight, TGIuint8 nSpriteSize, bool bFullScreen, bool bRotateScreen)
{
 	TGIGlobals::nSpriteSize = nSpriteSize;
	TGIGlobals::bRotateScreen = bRotateScreen;

	TGIGlobals::screenWidth = screenWidth;
	TGIGlobals::screenHeight = screenHeight;



	//SDL init
	TGIint err  = 0;
#ifndef __NDS__
	err = SDL_Init(SDL_INIT_VIDEO | SDL_INIT_JOYSTICK);
#endif

	if (err < 0)
	{ 
		TGIGlobals::Trace("Cant initiate SDL: %s\n", SDL_GetError()); 
		return false;
	}
	TGIGlobals::Trace("SDL initiated");

	//const SDL_VideoInfo *info = SDL_GetVideoInfo();

	//toute la SDL

#ifdef DESKTOP
	if (bFullScreen)
	{
		TGIGlobals::pScreen = SDL_SetVideoMode(TGIGlobals::screenWidth*nSpriteSize, TGIGlobals::screenHeight*nSpriteSize, 16, SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN|SDL_ASYNCBLIT);
	}
	else
	{
		TGIGlobals::pScreen = SDL_SetVideoMode(TGIGlobals::screenWidth*nSpriteSize, TGIGlobals::screenHeight*nSpriteSize, 16, SDL_HWSURFACE|SDL_DOUBLEBUF);
	}
	if (pScreen == NULL)
	{
		TGIGlobals::Trace("Error while initializing screen\n");
		return false;
	}
	//joysticks
	int nJoys = SDL_NumJoysticks() - 1;
	SDL_Joystick* pJoy;
	for (;nJoys>=0;nJoys--)
	{
		pJoy = SDL_JoystickOpen(nJoys);
		if (pJoy)
		{
			vecJoystick.push_back(pJoy);
		}
	}
	//sound
#ifndef TGI_NOSOUND
	SDL_InitSubSystem(SDL_INIT_AUDIO);
	int n;
	n = Mix_OpenAudio(22050, AUDIO_S16SYS, 2, 2048);
	Mix_HookMusicFinished(music_finished);
#endif
#endif

#ifdef GP2X
	

	TGIGlobals::nSpriteSize = 2;
	TGIGlobals::screenWidth = 800;
	TGIGlobals::screenHeight = 480;

	TGIGlobals::pScreen = SDL_SetVideoMode(TGIGlobals::screenWidth*nSpriteSize, TGIGlobals::screenHeight*nSpriteSize, 16, SDL_SWSURFACE);
	if (pScreen == NULL)
	{
		TGIGlobals::Trace("Error while initializing screen\n");
		return false;
	}
	//joysticks
	int nJoys = SDL_NumJoysticks() - 1;
	SDL_Joystick* pJoy;
	for (;nJoys>=0;nJoys--)
	{
		pJoy = SDL_JoystickOpen(nJoys);
		if (pJoy)
		{
			vecJoystick.push_back(pJoy);
		}
	}
	//sound
#ifndef TGI_NOSOUND
	SDL_InitSubSystem(SDL_INIT_AUDIO);
	int n;
	n = Mix_OpenAudio(22050, AUDIO_S16SYS, 2, 128);
	Mix_HookMusicFinished(music_finished);
#endif

	SDL_ShowCursor(0);
#endif
	
#ifdef __NDS__
	

	

	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE); //sub bg 0 will be used to print text
	vramSetBankH(VRAM_H_SUB_BG);
	vramSetBankI(VRAM_I_LCD);  
	////////////////set up text background for text/////////////////////
    //SUB_BG0_CR = BG_MAP_BASE(8);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);//by default font will be rendered with color 255
	//consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(8), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);
	consoleDemoInit();

	TGIGlobals::nSpriteSize = 2;
	TGIGlobals::screenWidth = 800;
	TGIGlobals::screenHeight = 480;

	TGIGlobals::Trace("SDL initiate"); 
	err = SDL_Init(SDL_INIT_VIDEO|SDL_INIT_JOYSTICK);
	

	TGIGlobals::pScreen = SDL_SetVideoMode(TGIGlobals::screenWidth*TGIGlobals::nSpriteSize, TGIGlobals::screenHeight*TGIGlobals::nSpriteSize, 8, SDL_SWSURFACE|SDL_HWPALETTE);
	if (pScreen == NULL)
	{
		TGIGlobals::Trace("Error while initializing screen\n");
		//return false;
	}

	//joysticks
	//int nJoys = 1;//SDL_NumJoysticks() - 1;
	SDL_Joystick* pJoy;
	pJoy = SDL_JoystickOpen(0);
	if (pJoy)
	{
		vecJoystick.push_back(pJoy);
	}

	if (!fatInitDefault())  
	{
		TGIGlobals::Trace("Unable to initialize media device!");
	}
	
	//sound
#ifndef TGI_NOSOUND
	mm_ds_system sys;
    // number of modules in your soundbank (defined in output header)
    sys.mod_count = MSL_NSONGS;
    
    // number of samples in your soundbank (defined in output header)
    sys.samp_count= MSL_NSAMPS;

    // memory bank, allocate BANKSIZE (or NSONGS+NSAMPS) words
    sys.mem_bank = (mm_word*)new char[ MSL_BANKSIZE * 4];

    // select fifo channel 
    sys.fifo_channel = FIFO_MAXMOD;
   
    // initialize maxmod
	TGIGlobals::Trace("mmInit");  
    mmInit( &sys );
	TGIGlobals::Trace("mmInit done");

	mmSelectMode(MM_MODE_A);

	TGIGlobals::Trace("mmSoundBankInFile"); 
    mmSoundBankInFiles("/dstroydata/soundbank.bin");
	TGIGlobals::Trace("mmSoundBankInFile done "); 
#endif

	SDL_ShowCursor(0);
#endif

	return true;
}

bool TGIGlobals::exit(void)
{
#ifndef TGI_NOSOUND
#ifndef __NDS__
	Mix_CloseAudio();
	SDL_QuitSubSystem(SDL_INIT_AUDIO);
#endif
#endif

	
	for (TGIuint16 i=0;i<vecJoystick.size();i++)
	{
		SDL_JoystickClose(vecJoystick[i]);
	}

	SDL_Quit();

#ifdef __NDS__
	//powerOFF(POWER_ALL);
#endif

	return true;
}


void TGIGlobals::endianConvert(TGIuint16 order, void* pData, TGIuint16 nLen)
{
	if (order == 255)
	{
		//no need to convert
		return;
	}

	TGIint i;
	TGIuint8 t;
	for (i=nLen/2-1;i>=0;i--)
	{
		t = ((TGIuint8*)pData)[i];
		((TGIuint8*)pData)[i] = ((TGIuint8*)pData)[nLen-i-1];
		((TGIuint8*)pData)[nLen-i-1] = t;
	}
}


bool TGIGlobals::playMusic(std::string cstrFile, TGIuint16 nRepeat, TGIuint16 nRepeatPos)
{
#ifndef TGI_NOSOUND
	char strDebug[256];
	sprintf(strDebug, "playMusic:%s", cstrFile.c_str());
	TGIGlobals::Trace(strDebug);
	TGIGlobals::stopMusic();

#ifndef __NDS__
	TGIGlobals::pMusic = Mix_LoadMUS(cstrFile.c_str());
	if (!TGIGlobals::pMusic)
		return false;
	TGIGlobals::nRepeatPos = nRepeatPos;
	TGIGlobals::nRepeat = nRepeat - 1;

	return Mix_PlayMusic(TGIGlobals::pMusic, 1) == 0;
#else
	nMusicRes = file2res(cstrFile.c_str());
	sprintf(strDebug, "ressource=%d", nMusicRes);
	TGIGlobals::Trace(strDebug);
		
	mmLoad(nMusicRes);
	mmStart( nMusicRes, MM_PLAY_LOOP );
#endif

#endif
	return false;
}

bool TGIGlobals::stopMusic(void)
{
#ifndef TGI_NOSOUND
#ifndef __NDS__
	if (TGIGlobals::pMusic)
	{
		Mix_HaltMusic();
		Mix_FreeMusic(TGIGlobals::pMusic);
		TGIGlobals::pMusic = NULL;
	}
#else
	//maxmod
	if (nMusicRes != -1)
	{
		if (mmActive())
		{
			mmStop( );
		}
		mmUnload(nMusicRes);

		nMusicRes = -1;
	}
#endif
#endif
	return true;
}
#ifndef TGI_NOSOUND
#ifndef __NDS__
void TGIGlobals::music_finished()
{

	if (nRepeat == 0)
		return;
	if (nRepeat > 0)
		nRepeat--;

	
	Mix_PlayMusic(TGIGlobals::pMusic, 1);
	Mix_PauseMusic();
	Mix_SetMusicPosition(nRepeatPos);
	Mix_ResumeMusic();

}
#endif
#endif
