/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtGui>
#include <QtSql>

#include "dlh.h"
#include "ui_dlh.h"
#include "about.h"

static bool createConnection()
{
    QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE");
    db.setDatabaseName(QDir::homePath().append("/MyDocs/dlh.db"));
    if (!db.open()) {
        QMessageBox::critical(0, QObject::tr("Cannot open database"),
        QObject::tr("Unable to establish a database connection.\n\n"
            "Click Cancel to exit."), QMessageBox::Cancel);
        return false;
    }
    QSqlQuery query;
    query.exec("create table dlh (start varchar(20) primary key, "
               "end varchar(20), wb number, wa number, dw number, "
               "mlb number, mla number, dml number)");
    return true;
}

Widget::Widget(QWidget *parent)
    : QWidget(parent), ui(new Ui::Widget)
{
    start = NULL;
    view = NULL;

    ui->setupUi(this);

    createConnection();
    connect(ui->mainStartButton, SIGNAL(clicked()), this, SLOT(CallStartDialog()));
    connect(ui->mainViewButton, SIGNAL(clicked()), this, SLOT(CallViewDialog()));
    connect(ui->mainAboutButton, SIGNAL(clicked()), this, SLOT(openAboutDialog()));
    connect(ui->mainResetButton, SIGNAL(clicked()), this, SLOT(reset()));

    QDBusConnection::sessionBus().registerService("com.nokia.dlh");
    QDBusConnection::sessionBus().registerObject("/com/nokia/dlh", this, QDBusConnection::ExportAllContents);

    setAttribute(Qt::WA_Maemo5StackedWindow);
}

Widget::~Widget()
{
    delete ui;
}

void Widget::CallStartDialog() {
    activateWindow();
    if (mutex.tryLock()) {
        start = new Start(this);
        start->setAttribute(Qt::WA_Maemo5StackedWindow);
        start->setWindowFlags(start->windowFlags() | Qt::Window);
        connect(start, SIGNAL(widgetClosed()), this, SLOT(free()));
        start->show();
    }
}

void Widget::CallViewDialog() {
    activateWindow();
    if (mutex.tryLock()) {
        view = new View(this);
        view->setAttribute(Qt::WA_Maemo5StackedWindow);
        view->setWindowFlags(view->windowFlags() | Qt::Window);
        connect(view, SIGNAL(widgetClosed()), this, SLOT(free()));
        view->show();
    }
}

void Widget::free() {
    if (start){
        delete start;
        start = NULL;
    }
    if (view){
        delete view;
        view = NULL;
    }
    mutex.unlock();
}

void Widget::openAboutDialog() {
    About about;
    about.exec();
}

void Widget::reset() {
    QMessageBox::StandardButton answer =
    QMessageBox::question(this, tr("Are you sure?"),
        tr("This operation is undoable!!!"),
        QMessageBox::Yes | QMessageBox::No,
        QMessageBox::No);
    if (answer == QMessageBox::Yes) {
        QSqlQuery query;
        QString command = QString("delete from dlh");
        query.exec(command);
    }
}
