/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtSql>

#include "view.h"
#include "ui_view.h"

View::View(QWidget *parent) :
    QWidget(parent),
    m_ui(new Ui::View)
{
    qDebug() << "View widget constructor";
    m_ui->setupUi(this);

    model.setTable("dlh");
    model.setEditStrategy(QSqlTableModel::OnManualSubmit);
    model.select();

    model.setHeaderData(0, Qt::Horizontal, QObject::tr("Start time"));
    model.setHeaderData(1, Qt::Horizontal, QObject::tr("Finish time"));
    model.setHeaderData(2, Qt::Horizontal, QObject::tr("Weight before"));
    model.setHeaderData(3, Qt::Horizontal, QObject::tr("Weight after"));
    model.setHeaderData(4, Qt::Horizontal, QObject::tr("Weight difference"));
    model.setHeaderData(5, Qt::Horizontal, QObject::tr("ml before"));
    model.setHeaderData(6, Qt::Horizontal, QObject::tr("ml after"));
    model.setHeaderData(7, Qt::Horizontal, QObject::tr("ml difference"));
    m_ui->tableView->init(&model);
}

View::~View()
{
    qDebug() << "View widget destructor";
    delete m_ui;
}

void View::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void View::closeEvent(QCloseEvent *event)
 {
    qDebug() << "Closing view widget";
    emit widgetClosed();
    event->accept();
 }
