TEMPLATE = app

CONFIG += qdbus

TARGET = digiclockwidget

HEADERS       = digitalclockwdg.h \
    dclocksettings.h \
    settingsdialog.h \
	fontclock.h \
	lcdclock.h
	
SOURCES       = digitalclockwdg.cpp \
                main.cpp \
    dclocksettings.cpp \
    settingsdialog.cpp \
	fontclock.cpp \
	lcdclock.cpp

maemo5 {
    include(qmaemo5homescreenadaptor/qmaemo5homescreenadaptor.pri)
}

TRANSLATIONS    = digiclock_ru.ts \
	digiclock_fr.ts

FORMS += \
    settingsdialog.ui

unix {
  #VARIABLES
#  isEmpty(PREFIX) {
	PREFIX = /
#  }
  BINDIR = $$PREFIX/opt/digiclockwidget
  DATADIR =$$PREFIX/usr/share

  DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

  #MAKE INSTALL

  INSTALLS += target desktop service iconxpm icon26 icon48 icon64 resfile

  target.path =$$BINDIR

  desktop.path = $$DATADIR/applications/hildon-home
  desktop.files += $${TARGET}.desktop

  service.path = $$DATADIR/dbus-1/services
  service.files += $${TARGET}.service

  iconxpm.path = $$DATADIR/pixmap
  iconxpm.files += ../data/maemo/$${TARGET}.xpm

  icon26.path = $$DATADIR/icons/hicolor/26x26/apps
  icon26.files += img/26x26/$${TARGET}.png

  icon48.path = $$DATADIR/icons/hicolor/48x48/apps
  icon48.files += img/48x48/$${TARGET}.png

  icon64.path = $$DATADIR/icons/hicolor/64x64/apps
  icon64.files += img/64x64/$${TARGET}.png
  
  resfile.path = $$BINDIR
  resfile.files += digiclock_ru.qm
  resfile.files += digiclock_fr.qm
}		