#include "mainwindow.h"
#include <QtGui/QApplication>
#include <QCoreApplication>
#include <QString>
#include <QDir>
#include <QObject>
#include <QGraphicsObject>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent)
{
    //view = new QDeclarativeView;
    QString dir;
    dir = QCoreApplication::applicationDirPath()
          + QLatin1String("/../qml/demine/main.qml");
    view.setSource(QUrl::fromLocalFile(dir));
    setCentralWidget(&view);
    view.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    view.show();
    QObject *rootObject = dynamic_cast<QObject*>(view.rootObject());

    newGame = new QAction(tr("&New game"), this);
    options = new QAction(tr("&Options"), this);
    menu = menuBar()->addMenu(tr("Demine"));
    menu->addAction(newGame);
    menu->addAction(options);

    connect(newGame, SIGNAL(triggered()), rootObject, SLOT(newGame()));
    connect(options, SIGNAL(triggered()), rootObject, SLOT(openOptions()));
}

MainWindow::~MainWindow()
{
    //delete ui;
}
