/*
* Copyright (c) 2011 Mladen Milankovic <mmlado at gmail.com>.
*
* This file is part of Demine application
*
* Sink Submarines is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Sink Submarines is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.

* You should have received a copy of the GNU General Public License
* along with Demine.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtGui/QApplication>
#include "qplatformdefs.h"
#if defined(Q_WS_MAEMO_5)
#include "mainwindow.h"
#else
#include "qmlapplicationviewer.h"
#endif


Q_DECL_EXPORT main(int argc, char *argv[])
{
    //const QRect screenGeometry = QApplication::desktop()->screenGeometry();
    QApplication app(argc, argv);
    app.setOrganizationName("mmlado");
    app.setOrganizationDomain("mmlado.com");
    app.setApplicationName("Demine");
    app.setApplicationVersion("0.1.0");

#if defined(Q_WS_MAEMO_5)
    MainWindow main;
    main.show();
#else
    QmlApplicationViewer viewer;
    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    //viewer.setOrientation(QmlApplicationViewer::ScreenOrientationLockLandscape);
#if defined(MEEGO_EDITION_HARMATTAN)
    viewer.setMainQmlFile(QLatin1String("/opt/demine/qml/demine/harmattan.qml"));
#else
    viewer.setMainQmlFile(QLatin1String("qml/demine/main.qml"));
#endif

    // Graphic flicker fix
    // "Avoiding graphics flicker in Qt / QML "
    // http://blog.rburchell.com/2011/11/avoiding-graphics-flicker-in-qt-qml.html
    // Don't know if it's needed, will leave here in any case
    //viewer.setAttribute(Qt::WA_OpaquePaintEvent);
    //viewer.setAttribute(Qt::WA_NoSystemBackground);
    //viewer.viewport()->setAttribute(Qt::WA_OpaquePaintEvent);
    //viewer.viewport()->setAttribute(Qt::WA_NoSystemBackground);

    viewer.setResizeMode(QDeclarativeView::SizeRootObjectToView);
    //viewer.showFullScreen();
    //view.setGeometry(screenGeometry);
    viewer.showExpanded();
#endif

    return app.exec();
}
