#ifndef DATE_TODAY_PLUGIN_H
#define DATE_TODAY_PLUGIN_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>


G_BEGIN_DECLS

typedef struct _DateTodayPlugin DateTodayPlugin;
typedef struct _DateTodayPluginClass DateTodayPluginClass;

#define DATE_TODAY_TYPE_PLUGIN (date_today_plugin_get_type())

#define DATE_TODAY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
								DATE_TODAY_TYPE_PLUGIN, DateTodayPlugin))

#define DATE_TODAY_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
								    DATE_TODAY_TYPE_PLUGIN))

#define DATE_TODAY_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
									  DATE_TODAY_TYPE_PLUGIN, DateTodayPluginClass))

struct _DateTodayPlugin
{
  HDHomePluginItem hitem;
  guint today;
  guint time_out_handler;
  GtkWidget* content;
  GtkWidget* settings_window;
  DBusGConnection *dbus_conn;
  DBusGProxy *dbus_proxy;
  guint launch_view; 
};

struct _DateTodayPluginClass
{
  HDHomePluginItemClass parent_class;

};

GType date_today_plugin_get_type(void);

#endif
