#include "youtubeplaylistlisttab.h"
#include "youtubeplaylistdelegate.h"
#include "youtubeplaylistvideoswindow.h"
#include "listview.h"
#include "../base/youtubeplaylistlistmodel.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include <QLabel>
#include <QGridLayout>
#include <QMaemo5Style>

YouTubePlaylistListTab::YouTubePlaylistListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new YouTubePlaylistListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No playlists found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMorePlaylists()));

    this->onOrientationChanged();
}

void YouTubePlaylistListTab::setPlaylistFeed(const QUrl &feed) {
    m_model->getPlaylists(feed);
}

void YouTubePlaylistListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubePlaylistListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubePlaylistListTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void YouTubePlaylistListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void YouTubePlaylistListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index.row()));
    }
}

void YouTubePlaylistListTab::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    YouTubePlaylistVideosWindow *window = new YouTubePlaylistVideosWindow(playlist, WindowStack::instance()->currentWindow());
    window->show();
}
