/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TUNEINSTATION_H
#define TUNEINSTATION_H

#include <QNetworkReply>
#include "../base/station.h"

class TuneInStation : public QObject
{
    Q_OBJECT

    Q_PROPERTY(Station* result
               READ result
               NOTIFY finished)
    Q_PROPERTY(QNetworkReply::NetworkError error
               READ error
               NOTIFY finished)
    Q_PROPERTY(QString errorString
               READ errorString
               NOTIFY finished)

public:
    explicit TuneInStation(QObject *parent = 0);
    ~TuneInStation();

    Station* result() const;

    QNetworkReply::NetworkError error() const;
    QString errorString() const;

public slots:
    void load(const QString &id);
    void cancel();

private:
    explicit TuneInStation(QNetworkReply *reply, QObject *parent = 0);

    void setResult(Station *result);

private slots:
    void onReplyFinished();

signals:
    void canceled(TuneInStation *station);
    void finished(TuneInStation *station);

private:
    friend class TuneIn;

    QNetworkReply *m_reply;

    Station *m_result;
};

#endif
