/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TUNEIN_H
#define TUNEIN_H

#include <QObject>
#include <QPair>

class QUrl;
class TuneInGenreList;
class TuneInLanguageList;
class TuneInNameList;
class TuneInStationList;
class TuneInStation;
class TuneInPodcastList;
class TuneInPodcastEpisodeList;

class TuneIn : public QObject
{
    Q_OBJECT

public:
    explicit TuneIn(QObject *parent = 0);
    ~TuneIn();

    Q_INVOKABLE static QList< QPair<QString, QString> > getCountries();

    Q_INVOKABLE static TuneInGenreList* getGenres();

    Q_INVOKABLE static TuneInLanguageList* getLanguages();

    Q_INVOKABLE static TuneInNameList* getNames(const QString &id, const QString &filter);

    Q_INVOKABLE static TuneInStationList* searchStations(const QString &query);
    Q_INVOKABLE static TuneInStationList* getStationsByCountry(const QString &id);
    Q_INVOKABLE static TuneInStationList* getStationsByGenre(const QString &id);
    Q_INVOKABLE static TuneInStationList* getStationsByName(const QString &id, const QString &name);
    Q_INVOKABLE static TuneInStationList* getStations(const QUrl &url);

    Q_INVOKABLE static TuneInStation* getStation(const QString &id);

    Q_INVOKABLE static TuneInPodcastList* searchPodcasts(const QString &query);
    Q_INVOKABLE static TuneInPodcastList* getPodcastsByCountry(const QString &id);
    Q_INVOKABLE static TuneInPodcastList* getPodcastsByGenre(const QString &id);
    Q_INVOKABLE static TuneInPodcastList* getPodcastsByName(const QString &id, const QString &name);
    Q_INVOKABLE static TuneInPodcastList* getPodcasts(const QUrl &url);

    Q_INVOKABLE static TuneInPodcastEpisodeList* getPodcastEpisodes(const QUrl &url);
};

#endif
