/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QImage>
#include "thumbnaildownloader.h"
#include "../base/networkaccessmanager.h"

ThumbnailDownloader::ThumbnailDownloader(QObject *parent) :
    QObject(parent)
{
}

ThumbnailDownloader::~ThumbnailDownloader() {}

void ThumbnailDownloader::downloadThumbnail(const QUrl &url) {
    QNetworkRequest request(url);
    QNetworkReply *reply = NetworkAccessManager::instance()->get(request);
    this->connect(reply, SIGNAL(finished()), this, SLOT(onThumbnailDownloaded()));
}

void ThumbnailDownloader::onThumbnailDownloaded() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        return;
    }

    emit gotThumbnail(reply);
}
