/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef NOWPLAYINGBUTTON_H
#define NOWPLAYINGBUTTON_H

#include <QWidget>

class StackedWindow;
class Station;

class NowPlayingButton : public QWidget
{
    Q_OBJECT

public:
    explicit NowPlayingButton(StackedWindow *parent = 0);
    ~NowPlayingButton();

    bool ready() const;

    static NowPlayingButton* instance();

public slots:
    void poke();

private:
    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);
    void paintEvent(QPaintEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    void triggerAnimation();
    void stopAnimation();
    void setReady(bool ready);
    bool moved() const;
    void setMoved(bool moved);
    
private slots:
    void onCurrentStationChanged(Station *station);
    void onPlaybackStateChanged();
    void onCurrentWindowChanged(StackedWindow *window);
    void onScreenLockStateChanged(bool locked);
    void onScreenOrientationChanged();
    void nextFrame();
    void showNowPlayingWindow();

signals:
    void readyChanged(bool ready);

private:
    static NowPlayingButton* self;

    QTimer *m_animationTimer;

    int m_currentFrame;

    QVector<QPixmap> m_images;

    bool m_ready;
    bool m_moved;
};

#endif // NOWPLAYINGBUTTON_H
