/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef LOGOLABEL_H
#define LOGOLABEL_H

#include <QWidget>

class QImage;
class QMouseEvent;
class QPaintEvent;

class LogoLabel : public QWidget
{
    Q_OBJECT

public:
    explicit LogoLabel(QWidget *parent = 0);

    inline bool interactive() const { return m_interactive; }
    inline void setInteractive(bool interactive) { m_interactive = interactive; }

    inline QImage image() const { return m_image; }
    void setImage(const QImage &image);

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    void leaveEvent(QEvent *event);
    void paintEvent(QPaintEvent *event);

signals:
    void clicked();

protected:
    QImage m_image;

    bool m_interactive;
    bool m_pressed;
};

#endif // LOGOLABEL_H
