/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PODCASTS_H
#define PODCASTS_H

#include <QObject>

class QUrl;
class Podcast;
class PodcastEpisodeList;

class Podcasts : public QObject
{
    Q_OBJECT

public:
    explicit Podcasts(QObject *parent = 0);
    ~Podcasts();

    Q_INVOKABLE static Podcast* getPodcast(const QUrl &url);

    Q_INVOKABLE static PodcastEpisodeList* getPodcastEpisodes(const QUrl &url);
};

#endif // PODCASTS_H
