#ifndef LOGODOWNLOADER_H
#define LOGODOWNLOADER_H

#include <QObject>
#include <QNetworkReply>

class LogoDownloader : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QUrl url
               READ url
               WRITE setUrl)
    Q_PROPERTY(QString localPath
               READ localPath
               WRITE setLocalPath)
    Q_PROPERTY(QNetworkReply::NetworkError error
               READ error
               NOTIFY finished)
    Q_PROPERTY(QString errorString
               READ errorString
               NOTIFY finished)

public:
    explicit LogoDownloader(QObject *parent = 0);
    explicit LogoDownloader(const QUrl &url, const QString &localPath, QObject *parent = 0);
    ~LogoDownloader();

    QUrl url() const;
    void setUrl(const QUrl &url);

    QString localPath() const;
    void setLocalPath(const QString &path);

    QNetworkReply::NetworkError error() const;
    QString errorString() const;
    
public slots:
    void start();
    void cancel();

private:
    int retries() const;
    void setRetries(int retries);
    
private slots:
    void retry(const QUrl &url);

    void onReplyFinished();

signals:
    void canceled(LogoDownloader *downloader);
    void finished(LogoDownloader *downloader);

private:
    QNetworkReply *m_reply;

    QUrl m_url;
    QString m_path;

    int m_retries;
};

#endif // LOGODOWNLOADER_H
