/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import com.cuteradio.items 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

MyPage {
    id: root

    function loadStation(stationItem) {
        root.state = "loading";
        root.title = stationItem.title;
        station.load(stationItem.id);
    }

    title: qsTr("Station info")
    tools: ToolBarLayout {

        BackToolIcon {}

        NowPlayingButton {}

        ToolIcon {
            platformIconId: "toolbar-add"
            onClicked: {
                loader.sourceComponent = addStationDialog;
                loader.item.loadStation(station.result);
                loader.item.open();
            }
        }
    }

    TuneInStation {
        id: station

        onFinished: {
            if (station.result) {
                root.state = "";
            }
            else {
                root.state = "error";
                infoBanner.displayMessage(station.errorString);
            }
        }
    }

    Flickable {
        id: flicker

        anchors {
            fill: parent
            margins: UI.PADDING_DOUBLE
        }
        contentHeight: column.height + UI.PADDING_DOUBLE

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }
            spacing: UI.PADDING_DOUBLE

            Logo {
                width: 120
                height: 120
                image: station.result ? station.result.logo : ""
                text: station.result ? station.result.title : ""
                enabled: (station.result != null) && ((!MediaPlayer.currentStation) || (MediaPlayer.currentStation.id != station.result.id))
                onClicked: appWindow.playStation(station.result)
            }

            Label {
                width: parent.width
                wrapMode: Text.WordWrap
                text: station.result ? station.result.description : ""
            }

            SeparatorLabel {
                width: parent.width
                text: qsTr("Properties")
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: station.result ? qsTr("Genre") + ": " + station.result.genre : ""
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: station.result ? qsTr("Country") + ": " + station.result.country : ""
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: station.result ? qsTr("Language") + ": " + station.result.language : ""
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: station.result ? qsTr("Source") + ": " + station.result.source : ""
            }
        }
    }

    ScrollDecorator {
        flickableItem: flicker
    }

    Label {
        id: errorLabel

        anchors {
            fill: parent
            margins: UI.PADDING_DOUBLE
        }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        font.bold: true
        font.pixelSize: 40
        text: qsTr("No information found")
        visible: false
    }

    BusyIndicator {
        id: busyIndicator

        anchors.centerIn: parent
        platformStyle: BusyIndicatorStyle {
            size: "large"
        }
        visible: false
        running: visible
    }

    Loader {
        id: loader
    }

    Component {
        id: addStationDialog

        TuneInAddStationDialog {}
    }

    states: [
        State {
            name: "loading"
            PropertyChanges { target: flicker; visible: false }
            PropertyChanges { target: busyIndicator; visible: true }
        },

        State {
            name: "error"
            PropertyChanges { target: flicker; visible: false }
            PropertyChanges { target: busyIndicator; visible: false }
            PropertyChanges { target: errorLabel; visible: true }
        }
    ]
}
