import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

QueryDialog {
    id: root

    function showBusyMessage(info, numberOfOperations) {
        if (info !== "") {
            infoLabel.text = info;
            progressBar.value = 0;
            progressBar.maximumValue = numberOfOperations;
            root.open();
        }
        else {
            root.close();
        }
    }

    function updateProgress(progress) {
        progressBar.value = progress;
    }

    rejectButtonText: qsTr("Cancel")
    content: Item {
        height: column.height
        anchors {
            left: parent.left
            right: parent.right
        }

        Column {
            id: column

            anchors {
                left: parent.left
                right: parent.right
                top: parent.top
            }
            spacing: UI.PADDING_DOUBLE

            Image {
                id: icon

                x: Math.floor((parent.width / 2) - (width / 2))
                source: "images/info.png"
            }

            Label {
                id: infoLabel

                width: parent.width
                horizontalAlignment: Text.AlignHCenter
                color: UI.COLOR_INVERTED_FOREGROUND
            }

            MyProgressBar {
                id: progressBar

                width: parent.width
                visible: maximumValue > 1
                onValueChanged: if (value === maximumValue) root.close();
            }
        }
    }
}
