/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TUNEINSTATIONFILTERLISTMODEL_H
#define TUNEINSTATIONFILTERLISTMODEL_H

#include <QSortFilterProxyModel>
#include "tuneinstationlistmodel.h"

class TuneInStationFilterListModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool moreResults
               READ moreResults
               NOTIFY loadingChanged)
    Q_PROPERTY(QUrl nextUrl
               READ nextUrl
               NOTIFY loadingChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QString searchQuery
               READ searchQuery
               NOTIFY searchQueryChanged)
    Q_PROPERTY(Queries::QueryType queryType
               READ queryType
               NOTIFY queryTypeChanged)
    Q_PROPERTY(QString query
               READ query
               WRITE setQuery
               NOTIFY queryChanged)
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    Q_PROPERTY(QString highlightColor
               READ highlightColor
               WRITE setHighlightColor)
#endif

public:
    enum Roles {
        QueryMatchRole = TuneInStationListModel::SectionRole + 1
    };

    explicit TuneInStationFilterListModel(QObject *parent = 0);
    ~TuneInStationFilterListModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif

    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    Q_INVOKABLE bool setData(int row, const QVariant &value, const QByteArray &role);

    bool moreResults() const;

    QUrl nextUrl() const;

    bool loading() const;

    QString searchQuery() const;

    Queries::QueryType queryType() const;

    QString query() const;

#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString highlightColor() const;
    void setHighlightColor(const QString &color);
#endif

    Station* get(const QModelIndex &index) const;
    Q_INVOKABLE Station* get(int row) const;

public slots:
    void setQuery(const QString &query);

    void searchStations(const QString &query);
    void showStationsByGenre(const QString &id);
    void showStationsByCountry(const QString &id);
    void showStations(const QString &url);

    void getMoreResults();

    void clear();
    void reload();

private:
    QString queryMatch(QString str) const;

private slots:
    void onQueryTypeChanged(Queries::QueryType queryType);

signals:
    void countChanged(int count);
    void loadingChanged(bool loading);
    void searchQueryChanged(const QString &query);
    void queryTypeChanged(Queries::QueryType queryType);
    void queryChanged(const QString &query);
    void highlightColorChanged(const QString &color);

private:
    TuneInStationListModel *m_model;
    QString m_query;
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString m_highlight;
#endif
    QHash<int, QByteArray> m_roleNames;
};

#endif // TUNEINSTATIONFILTERLISTMODEL_H
