/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TUNEINNAMELIST_H
#define TUNEINNAMELIST_H

#include <QNetworkReply>

class TuneInNameList : public QObject
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ count
               NOTIFY finished)
    Q_PROPERTY(QNetworkReply::NetworkError error
               READ error
               NOTIFY finished)
    Q_PROPERTY(QString errorString
               READ errorString
               NOTIFY finished)

public:
    ~TuneInNameList();

    int count() const;

    QList< QPair<QString, QString> > results() const;

    QNetworkReply::NetworkError error() const;
    QString errorString() const;

public slots:
    void cancel();

private:
    explicit TuneInNameList(QNetworkReply *reply, QObject *parent = 0);

private slots:
    void onReplyFinished();

signals:
    void canceled(TuneInNameList *list);
    void finished(TuneInNameList *list);

private:
    friend class TuneIn;

    QNetworkReply *m_reply;

    QList< QPair<QString, QString> > m_results;
};

#endif
