/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef THUMBNAILDOWNLOADER_H
#define THUMBNAILDOWNLOADER_H

#include <QObject>
#include <QNetworkReply>
#include <QUrl>

class QImage;

class ThumbnailDownloader : public QObject
{
    Q_OBJECT

public:
    explicit ThumbnailDownloader(QObject *parent = 0);
    ~ThumbnailDownloader();

public slots:
    void downloadThumbnail(const QUrl &url);

private slots:
    void onThumbnailDownloaded();

signals:
    void gotThumbnail(QNetworkReply* reply);
};

#endif // THUMBNAILDOWNLOADER_H
