/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef THUMBNAILCACHE_H
#define THUMBNAILCACHE_H

#include <QObject>
#include <QQueue>
#include <QImage>
#include <QCache>

class Thumbnail;
class QNetworkReply;
class QUrl;

class ThumbnailCache : public QObject
{
    Q_OBJECT

public:
    ThumbnailCache(QObject *parent = 0);
    ~ThumbnailCache();

    bool event(QEvent *event);

    static ThumbnailCache *instance();

public slots:
    QImage thumbnail(const QUrl &url, const QSize &scale = QSize());
    void onThumbnailDownloaded(QNetworkReply *reply);

protected:
    void run();

private:
    void nextThumbnail();    

signals:
    void thumbnailReady();
    void downloadThumbnail(const QUrl &url);

private:
    static ThumbnailCache *self;
    static QThread *cacheThread;
    static QCache<QUrl, Thumbnail> thumbnails;

    QQueue<QUrl> m_urls;
};

#endif
