/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef TUNEINSTATIONINFOWINDOW_H
#define TUNEINSTATIONINFOWINDOW_H

#include "stackedwindow.h"

class QUrl;
class Station;
class QLabel;
class ScrollArea;
class LogoLabel;
class TuneInStation;

class TuneInStationInfoWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit TuneInStationInfoWindow(const QString &id, QWidget *parent = 0);

private slots:
    void playStation();
    void showAddStationDialog();

    void onCurrentStationChanged(Station *station);

    void onLastPlayedChanged(qint64 lastPlayed);

    void onStationFinished(TuneInStation *station);

    void setLogo();

private:
    Station *m_station;

    QAction *m_playAction;
    QAction *m_addAction;

    QLabel *m_descriptionLabel;
    QLabel *m_genreLabel;
    QLabel *m_countryLabel;
    QLabel *m_languageLabel;
    QLabel *m_sourceLabel;
    QLabel *m_lastPlayedLabel;

    LogoLabel *m_logoLabel;

    ScrollArea *m_scrollArea;
};

#endif // TUNEINSTATIONINFOWINDOW_H
