/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QApplication>
#include <QTranslator>
#include "mainwindow.h"
#include "launcher.h"
#include "../base/database.h"
#include "../base/settings.h"
#include "../base/utils.h"
#include "../base/streamextractor.h"
#include "../thumbnailcache/thumbnailcache.h"
#ifdef MOBILITY_PLAYER
#include "../mediaplayer/mobility/mediaplayer.h"
#else
#include "../mediaplayer/phonon/mediaplayer.h"
#endif

int main(int argc, char *argv[]) {
    QApplication app(argc, argv);
    app.setOrganizationName("cuteRadio");
    app.setApplicationName("cuteRadio");
    app.setApplicationVersion(Utils::versionNumber());

    qRegisterMetaType< QList<Station*> >("QList<Station*>");
    qRegisterMetaType< QList<QPair<QString,int> > >("QList<QPair<QString,int> >");

    Settings settings;
    Database database;
    Utils utils;
    StreamExtractor extractor;
    MediaPlayer player;
    Launcher launcher;
    ThumbnailCache cache;

    if (!settings.language().isEmpty()) {
        QTranslator translator;
        translator.load(QString("/opt/cuteradio/translations/%1").arg(settings.language()));
        app.installTranslator(&translator);
    }

    settings.setNetworkProxy();

    MainWindow window;
    window.show();

    QObject::connect(&extractor, SIGNAL(gotStreamUrl(QUrl)), &launcher, SLOT(launch(QUrl)));

    return app.exec();
}
