/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "launcher.h"
#include "../base/settings.h"
#include <QTemporaryFile>
#include <QDir>
#include <QTimer>
#include <QProcess>
#include <QDBusConnection>
#include <QDBusInterface>

Launcher* Launcher::self = 0;

Launcher::Launcher(QObject *parent) :
    QObject(parent)
{
    if (!self) {
        self = this;
    }
}

Launcher::~Launcher() {}

Launcher* Launcher::instance() {
    return !self ? new Launcher : self;
}

void Launcher::launch(const QUrl &url) {
    if (Settings::instance()->mediaPlayer() == "other") {
        QStringList args = Settings::instance()->mediaPlayerCommand().split(' ', QString::SkipEmptyParts);
        QProcess *player = new QProcess;
        QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start(args.takeFirst(), args << url.toString());
    }
    else {
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + Settings::instance()->mediaPlayer(), "/com/nokia/" + Settings::instance()->mediaPlayer(), "com.nokia." + Settings::instance()->mediaPlayer(), bus);
        dbus_iface.call("mime_open", url.toString());
    }
}

void Launcher::launch(QList<QUrl> urls) {
    QTemporaryFile *temp = new QTemporaryFile;
    temp->setFileName(QDir::tempPath() + "/musikloud.m3u");

    if (temp->open()) {
        while (!urls.isEmpty()) {
            temp->write(urls.takeFirst().toString().toUtf8() + '\n');
        }

        if (Settings::instance()->mediaPlayer() == "other") {
            QStringList args = Settings::instance()->mediaPlayerCommand().split(' ', QString::SkipEmptyParts);
            QProcess *player = new QProcess;
            QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
            player->start(args.takeFirst(), args << temp->fileName());
        }
        else {
            QDBusConnection bus = QDBusConnection::sessionBus();
            QDBusInterface dbus_iface("com.nokia." + Settings::instance()->mediaPlayer(), "/com/nokia/" + Settings::instance()->mediaPlayer(), "com.nokia." + Settings::instance()->mediaPlayer(), bus);
            dbus_iface.call("mime_open", temp->fileName());
        }
    }

    temp->close();
    QTimer::singleShot(5000, temp, SLOT(deleteLater()));
}
