/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef STREAMEXTRACTOR_H
#define STREAMEXTRACTOR_H

#include <QObject>

class QUrl;

class StreamExtractor : public QObject
{
    Q_OBJECT

public:
    explicit StreamExtractor(QObject *parent = 0);
    ~StreamExtractor();

    static StreamExtractor* instance();

    bool busy() const;

    bool canceled() const;
    
public slots:
    void getStreamUrl(const QUrl &url);

    void cancelCurrentOperation();

private:
    int retries() const;
    void setRetries(int retries);

    void setBusy(bool isBusy, const QString &message = QString(), int numberOfOperations = 1);

    void setCanceled(bool canceled);

    void retry(const QUrl &url);

private slots:
    void parseResponse();

signals:
    void gotStreamUrl(const QUrl &url);
    void currentOperationCanceled();
    void busy(const QString &message, int numberOfOperations);
    void busyProgressChanged(int progress);
    void busyChanged(bool isBusy);
    void error(const QString &errorString);

private:
    static StreamExtractor *self;

    int m_retries;

    bool m_busy;
    bool m_canceled;
};

#endif // STREAMEXTRACTOR_H
