/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1
import com.cuteradio.models 1.0

MyPage {
    id: root

    title: qsTr("Stations by genre")
    tools: ToolBarLayout {

        BackToolButton {}

        NowPlayingButton {}
    }

    MyListView {
        id: view

        anchors.fill: parent
        model: TuneInPairListModel {
            id: genreModel

            Component.onCompleted: showGenres()
        }
        delegate: TuneInGenreDelegate {
            onClicked: {
                var page = appWindow.pageStack.push(Qt.resolvedUrl("TuneInNameListPage.qml"), { title: name });
                page.showNames(value, "s");
            }
        }
        section.delegate: SectionDelegate {
            text: section
        }
        section.property: "section"
        section.criteria: ViewSection.FirstCharacter
    }

    MySectionScroller {
        listView: view
    }

    Label {
        anchors {
            fill: parent
            margins: platformStyle.paddingLarge
        }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        color: platformStyle.colorNormalMid
        font.bold: true
        font.pixelSize: 32
        text: qsTr("No genres found")
        visible: (!genreModel.count) && (!genreModel.loading)
    }

    BusyIndicator {
        anchors.centerIn: parent
        width: 64
        height: 64
        visible: genreModel.loading
        running: visible
    }
}
