/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef FILTERBOX_H
#define FILTERBOX_H

#include <QToolBar>
#include <QLineEdit>

class QAction;

class FilterBox : public QToolBar
{
    Q_OBJECT

public:
    explicit FilterBox(QWidget *parent = 0);
    inline QString filterText() const { return m_filterEdit->text(); }

public slots:
    inline void setFilterText(const QString &text) { m_filterEdit->setText(text); }
    void clear();

signals:
    void filterTextChanged(const QString &text);
    void cleared();
    
private:
    QLineEdit *m_filterEdit;
    QAction *m_cancelAction;
};

#endif // FILTERBOX_H
