/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QSettings>
#include "enums.h"

class Settings : public QSettings
{
    Q_OBJECT

    Q_PROPERTY(ScreenOrientation::Orientation screenOrientation
               READ screenOrientation
               WRITE setScreenOrientation
               NOTIFY screenOrientationChanged)
    Q_PROPERTY(int sleepTimerDuration
               READ sleepTimerDuration
               WRITE setSleepTimerDuration
               NOTIFY sleepTimerDurationChanged)
    Q_PROPERTY(QString language
               READ language
               WRITE setLanguage
               NOTIFY languageChanged)
    Q_PROPERTY(bool networkProxyEnabled
               READ networkProxyEnabled
               WRITE setNetworkProxyEnabled
               NOTIFY networkProxyEnabledChanged)
    Q_PROPERTY(NetworkProxyType::ProxyType networkProxyType
               READ networkProxyType
               WRITE setNetworkProxyType
               NOTIFY networkProxyTypeChanged)
    Q_PROPERTY(QString networkProxyHostName
               READ networkProxyHostName
               WRITE setNetworkProxyHostName
               NOTIFY networkProxyHostNameChanged)
    Q_PROPERTY(quint16 networkProxyPort
               READ networkProxyPort
               WRITE setNetworkProxyPort
               NOTIFY networkProxyPortChanged)
    Q_PROPERTY(QString networkProxyUser
               READ networkProxyUser
               WRITE setNetworkProxyUser
               NOTIFY networkProxyUserChanged)
    Q_PROPERTY(QString networkProxyPassword
               READ networkProxyPassword
               WRITE setNetworkProxyPassword
               NOTIFY networkProxyPasswordChanged)
#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    Q_PROPERTY(QString activeColor
               READ activeColor
           #ifndef Q_OS_SYMBIAN
               WRITE setActiveColor
               NOTIFY activeColorChanged)
#else
               CONSTANT)
#endif
    Q_PROPERTY(QString activeColorString
               READ activeColorString
           #ifndef Q_OS_SYMBIAN
               WRITE setActiveColorString
               NOTIFY activeColorStringChanged)
#else
               CONSTANT)
#endif
#endif

public:
    explicit Settings(QObject *parent = 0);
    ~Settings();

    static Settings* instance();

    ScreenOrientation::Orientation screenOrientation() const;
    void setScreenOrientation(ScreenOrientation::Orientation orientation);

    int sleepTimerDuration() const;
    void setSleepTimerDuration(int duration);

    QString language() const;
    void setLanguage(const QString &language);

    bool networkProxyEnabled() const;
    void setNetworkProxyEnabled(bool enabled);

    NetworkProxyType::ProxyType networkProxyType() const;
    void setNetworkProxyType(NetworkProxyType::ProxyType type);

    QString networkProxyHostName() const;
    void setNetworkProxyHostName(const QString &host);

    quint16 networkProxyPort() const;
    void setNetworkProxyPort(quint16 port);

    QString networkProxyUser() const;
    void setNetworkProxyUser(const QString &username);

    QString networkProxyPassword() const;
    void setNetworkProxyPassword(const QString &password);

#if (defined QML_USER_INTERFACE) && (!defined Q_WS_MAEMO_5)
    QString activeColor() const;
#ifndef Q_OS_SYMBIAN
    void setActiveColor(const QString &color);
#endif

    QString activeColorString() const;
#ifndef Q_OS_SYMBIAN
    void setActiveColorString(const QString &colorString);
#endif
#endif

public slots:
    void setNetworkProxy();

signals:
    void screenOrientationChanged(ScreenOrientation::Orientation orientation);

    void sleepTimerEnabledChanged(bool enabled);
    void sleepTimerDurationChanged(int duration);

    void languageChanged(const QString &language);

    void networkProxyEnabledChanged(bool enabled);
    void networkProxyTypeChanged(NetworkProxyType::ProxyType type);
    void networkProxyHostNameChanged(const QString &host);
    void networkProxyPortChanged(quint16 port);
    void networkProxyUserChanged(const QString &username);
    void networkProxyPasswordChanged(const QString &password);

#if (defined QML_USER_INTERFACE) && !((defined Q_WS_MAEMO_5) || (defined Q_OS_SYMBIAN))
    void activeColorChanged(const QString &color);
    void activeColorStringChanged(const QString &colorString);
#endif
    
private:
    static Settings *self;
};

#endif // SETTINGS_H
