/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QPainter>
#include "homescreenlistdelegate.h"

HomescreenListDelegate::HomescreenListDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void HomescreenListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 8);
    textRect.setRight(textRect.right() - 64);

    QFont font;
    font.setBold(true);
    painter->setFont(font);
    painter->drawText(textRect, Qt::AlignVCenter, index.data().toString());

    QRect imageRect = option.rect;
    imageRect.setTopLeft(QPoint(imageRect.right() - 56, imageRect.top() + 16));
    imageRect.setSize(QSize(48, 48));

    painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/general_forward.png"));

    painter->restore();
}

QSize HomescreenListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 80);
}
