/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1

MySelectionListItem {
    id: root

    property variant initialValue
    property variant currentValue
    property alias model: selectionDialog.model

    signal valueChosen(variant value)

    function setInitialValue(value) {
        var found = false;
        var i = 0;
        while ((!found) && (i < model.count)) {
            if (model.get(i).value === value) {
                selectionDialog.selectedIndex = i;
                found = true;
            }
            i++;
        }

        currentValue = value;
    }

    width: parent.width
    platformInverted: false
    subTitle: selectionDialog.selectedIndex < 0 ? "" : model.get(selectionDialog.selectedIndex).name
    onClicked: selectionDialog.open()

    Component.onCompleted: if (initialValue !== undefined) setInitialValue(initialValue);

    MySelectionDialog {
        id: selectionDialog

        selectedIndex: -1
        titleText: root.title
        onAccepted: valueChosen(model.get(selectedIndex).value)
        onStatusChanged: if (status === DialogStatus.Closed) root.forceActiveFocus();
    }
}
