var Requests = (function() {
    var requests = {
        deleteResource: function(url, onsuccess, onerror) {
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == 4) {
                    switch (request.status) {
                        case 200:
                            if (typeof onsuccess === "function") {
                                onsuccess.call(Requests, request);
                            }

                            break;
                        case 302:
                            Requests.get(request.getResponseHeader("Location"), onsuccess, onerror);
                            break;
                        default:
                            if (typeof onerror === "function") {
                                onerror.call(Requests, request);
                            }
                            
                            break;
                    }
                }
            }

            request.open("DELETE", url);
            request.send();
        },

        get: function(url, onsuccess, onerror) {
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == 4) {
                    switch (request.status) {
                        case 200:
                            if (typeof onsuccess === "function") {
                                onsuccess.call(Requests, request);
                            }

                            break;
                        case 302:
                            Requests.get(request.getResponseHeader("Location"), onsuccess, onerror);
                            break;
                        default:
                            if (typeof onerror === "function") {
                                onerror.call(Requests, request);
                            }
                            
                            break;
                    }
                }
            }

            request.open("GET", url);
            request.send();
        },

        head: function(url, onsuccess, onerror) {
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == 4) {
                    switch (request.status) {
                        case 200:
                            if (typeof onsuccess === "function") {
                                onsuccess.call(Requests, request);
                            }

                            break;
                        default:
                            if (typeof onerror === "function") {
                                onerror.call(Requests, request);
                            }
                            
                            break;
                    }
                }
            }

            request.open("HEAD", url);
            request.send();
        },

        post: function(url, data, onsuccess, onerror) {
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == 4) {
                    switch (request.status) {
                        case 200:
                        case 201:
                            if (typeof onsuccess === "function") {
                                onsuccess.call(Requests, request);
                            }

                            break;
                        case 302:
                            Requests.get(request.getResponseHeader("Location"), onsuccess, onerror);
                            break;
                        default:
                            if (typeof onerror === "function") {
                                onerror.call(Requests, request);
                            }
                            
                            break;
                    }
                }
            }

            request.open("POST", url);
            request.send(data);
        },

        put: function(url, data, onsuccess, onerror) {
            var request = new XMLHttpRequest();
            request.onreadystatechange = function() {
                if (request.readyState == 4) {
                    switch (request.status) {
                        case 200:
                        case 201:
                            if (typeof onsuccess === "function") {
                                onsuccess.call(Requests, request);
                            }

                            break;
                        case 302:
                            Requests.get(request.getResponseHeader("Location"), onsuccess, onerror);
                            break;
                        default:
                            if (typeof onerror === "function") {
                                onerror.call(Requests, request);
                            }
                            
                            break;
                    }
                }
            }

            request.open("PUT", url);
            request.send(data);
        }
    };

    return requests;
})();
