/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import QtQuick.Controls 1.1

ItemDelegate {
    id: root
    
    Image {
        id: icon
        
        width: height
        anchors {
            left: parent.left
            top: parent.top
            bottom: parent.bottom
            margins: 2
        }
        source: model.iconPath
        smooth: true
    }
                
    Label {
        anchors {
            left: icon.right
            right: unreadIndicator.left
            margins: 2
        }
        verticalAlignment: Text.AlignVCenter
        font.bold: model.unreadArticles > 0
        color: styleData.textColor
        elide: styleData.elideMode
        text: styleData.value
    }
    
    Rectangle {
        id: unreadIndicator
        
        visible: model.unreadArticles > 0
        width: unreadLabel.width + 4
        anchors {
            right: parent.right
            top: parent.top
            bottom: parent.bottom
            margins: 2
        }
        color: palette.mid
        
        Label {
            id: unreadLabel
            
            anchors.centerIn: parent
            font.bold: true
            color: palette.light
            text: model.unreadArticles
        }
    }
}
