/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import QtQuick.Controls 1.1
import QtQuick.Layouts 1.1

MyDialog {
    id: root
    
    minimumWidth: grid.width + 20
    minimumHeight: grid.height + 60
    title: qsTr("New subscription")
    content: GridLayout {
        id: grid
        
        columns: 2
        
        Label {
            text: qsTr("Source") + ":"
        }
        
        TextField {
            id: sourceField
            
            Layout.minimumWidth: 300
        }
        
        Label {
            text: qsTr("Source type") + ":"
        }
        
        ComboBox {
            id: sourceSelector
            
            Layout.minimumWidth: 300
            model: [qsTr("URL"), qsTr("Local file"), qsTr("Command")]
        }        
    }
    
    buttons: [
        Button {
            text: qsTr("&Cancel")
            iconName: "dialog-cancel"
            onClicked: root.reject()
        },
        
        Button {
            text: qsTr("&Ok")
            iconName: "dialog-ok"
            isDefault: true
            enabled: sourceField.text != ""
            onClicked: {
                database.addSubscription([null, 0, "", 0, "", 0, sourceField.text, sourceSelector.currentIndex,
                                          qsTr("New subscription"), 0, ""]);
                root.accept();
            }
        }
    ]
}
