/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "article.h"
#include "articlemodel.h"
#include "database.h"
#include "download.h"
#include "downloadmodel.h"
#include "definitions.h"
#include "settings.h"
#include "subscription.h"
#include "subscriptionmodel.h"
#include "subscriptions.h"
#include "urlopener.h"
#include "utils.h"
#include <QSqlQuery>
#include <QThread>
#include <QApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>
#include <qqml.h>

void registerTypes() {
    qRegisterMetaType<QSqlQuery>("QSqlQuery");
    qRegisterMetaType< QList<QVariantList> >("QList<QVariantList>");
    qmlRegisterType<Article>("cuteNews", 1, 0, "Article");
    qmlRegisterType<ArticleModel>("cuteNews", 1, 0, "ArticleModel");
    qmlRegisterType<Subscription>("cuteNews", 1, 0, "Subscription");
    qmlRegisterType<SubscriptionModel>("cuteNews", 1, 0, "SubscriptionModel");
    qmlRegisterUncreatableType<Download>("cuteNews", 1, 0, "Download", "");
}

Q_DECL_EXPORT int main(int argc, char *argv[]) {
    QApplication app(argc, argv);
    app.setOrganizationName("cuteNews");
    app.setApplicationName("cuteNews");
    app.setApplicationVersion(VERSION_NUMBER);
    //app.setWindowIcon(QIcon::fromTheme("cutenews"));
    
    QScopedPointer<Database> database(Database::instance());
    QScopedPointer<DownloadModel> downloads(DownloadModel::instance());
    QScopedPointer<Settings> settings(Settings::instance());
    QScopedPointer<Subscriptions> subscriptions(Subscriptions::instance());
    QScopedPointer<UrlOpener> urlopener(UrlOpener::instance());
    Utils utils;
    
    QThread thread;
    Database::instance()->moveToThread(&thread);
    thread.start();
    
    registerTypes();
    
    QQmlApplicationEngine engine;
    QQmlContext *context = engine.rootContext();
    context->setContextProperty("database", Database::instance());
    context->setContextProperty("downloads", DownloadModel::instance());
    context->setContextProperty("settings", Settings::instance());
    context->setContextProperty("subscriptions", Subscriptions::instance());
    context->setContextProperty("urlopener", UrlOpener::instance());
    context->setContextProperty("utils", &utils);
    context->setContextProperty("VERSION_NUMBER", VERSION_NUMBER);
    engine.load("/opt/cutenews/qml/main.qml");
    
    QObject::connect(&app, SIGNAL(aboutToQuit()), &thread, SLOT(quit()));
    QObject::connect(&app, SIGNAL(aboutToQuit()), DownloadModel::instance(), SLOT(save()));
    
    return app.exec();
}
