/*
*  currency exchange widget for the maemo desktop.
*  Copyright (C) 2010 binop consulting group
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*  
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*  
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gtk/gtk.h>

#include <pthread.h>
#include <hildon/hildon.h>
#include <libintl.h> 
#include <libhildondesktop/libhildondesktop.h>
#include <stdlib.h>
#include "lib-currency-home-widget.h"
#include <conic/conic.h>
#include <string.h>

extern int n_currencies;
extern char *currencies[];
extern char *countries[];


gboolean update_values(CurrencyWidget *desktop_plugin);

static GtkWidget *update_ui(CurrencyWidget *plug) {

    char tmp_string[100];
   
    if (  plug->curset->not_updated == 1 ) {
        sprintf(tmp_string, "%s = <span fgcolor='#E47833'>%s </span>%s", plug->curset->active_currency->name, plug->curset->active_currency->value, plug->curset->name);
    }
    else {
        sprintf(tmp_string, "%s = %s %s", plug->curset->active_currency->name, plug->curset->active_currency->value , plug->curset->name);
    }
   
   
    gtk_label_set_markup(GTK_LABEL(plug->info_label), tmp_string);
    //gtk_label_set_text(plug->info_label, tmp_string);

    gtk_widget_destroy(plug->curr_flag);
    plug->curr_flag = gtk_image_new_from_file (plug->curset->active_currency->icon);
    gtk_container_add(GTK_CONTAINER(plug->curr_box), plug->curr_flag);
    gtk_box_reorder_child (GTK_BOX(plug->curr_box), GTK_WIDGET(plug->curr_flag), 0);

    gtk_widget_show_all(GTK_WIDGET(plug->contents));

} 

void  build_ui (CurrencyWidget *plug)
{

    GtkWidget *box = GTK_VBOX (gtk_vbox_new (TRUE,5));
    plug->contents =  gtk_vbox_new(TRUE, 5);

    // Create a new icon factory
    create_icon_factory();

    plug->main_event_box = gtk_event_box_new();

    plug->curr_box = GTK_HBOX (gtk_hbox_new(FALSE,0));
    plug->info_label = GTK_LABEL (gtk_label_new(NULL));


    gtk_box_pack_start(GTK_BOX(plug->curr_box), GTK_WIDGET(plug->info_label), TRUE, FALSE, 0);


    gtk_box_pack_start(GTK_BOX (box), GTK_WIDGET (plug->curr_box), TRUE, FALSE, 0); 


    gtk_container_add(GTK_CONTAINER(plug->main_event_box), box);
    gtk_event_box_set_visible_window ( GTK_EVENT_BOX (plug->main_event_box), FALSE);
    gtk_box_pack_start(GTK_BOX(plug->contents), GTK_WIDGET(plug->main_event_box), TRUE, FALSE, 0);

    gtk_widget_show_all(GTK_WIDGET(plug->contents));

}


enum { 
    ICON_COLUMN,
    TITLE_COLUMN,
    NUM_COLS
};


gboolean
callback( GtkWidget *widget,   GdkEventButton* event, CurrencyWidget *desktop_plugin )
{

    int i,j;

    int  currency_changed = 0;

    GtkWidget *dialog;
    char tmp[100];
    sprintf(tmp, "Last update: ");
    
    int minutes = difftime(time(NULL), desktop_plugin->curset->last_update) / 60.0;
    int hours = minutes / 60;
    int days = hours / 24;

    
    if ( days != 0 ) {
      if ( days == 1 ) {
          sprintf(tmp, "%s%d day, ",tmp, days);
      }
      else {
        sprintf(tmp, "%s%d days, ",tmp, days);
      }
    }

    if ( hours % 24 != 0) {
        if ( hours % 24 == 1) {
            sprintf(tmp, "%s%d hour and ", tmp, hours);
        }
        else {
            sprintf(tmp, "%s%d hours and ", tmp,hours % 24);
        }
    }

    if ( minutes == 0 || minutes == 1 ) {
        sprintf(tmp, "%s1 minute ago", tmp);
    }
    else {
        sprintf(tmp, "%s%d minutes ago", tmp,minutes % 60);
    }

        
        
    dialog = gtk_dialog_new_with_buttons(tmp, NULL, (GtkDialogFlags)0, "About", GTK_RESPONSE_ABOUT, dgettext("hildon-libs", "wdgt_bd_done"), GTK_RESPONSE_ACCEPT,  NULL);
    gtk_window_set_default_size(GTK_WINDOW(dialog), -1, 230);

    /* Create tree model */
    GtkListStore *list_store[5];
    GtkWidget *selector[5];
    GtkTreeIter iter[5];
    HildonTouchSelectorColumn *column[5];
    GtkCellRenderer *renderer[5];
    GtkWidget *button[5];

    GtkWidget *pan_content = gtk_vbox_new(TRUE,2);
    GtkWidget *pan = hildon_pannable_area_new();
    GtkWidget *content = gtk_dialog_get_content_area(GTK_DIALOG(dialog));



    // Create selectors 
    for ( j = 0; j  < 2 ; j++ ) {

        selector[j] = hildon_touch_selector_new();
        list_store[j] = gtk_list_store_new (NUM_COLS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

        for ( i = 0; i < n_currencies; i ++ ) {
            gtk_list_store_append(list_store[j], &iter[j]);

            char tmp_string[100];
            sprintf(tmp_string, "%s     %s", currencies[i], countries[i]);
            gtk_list_store_set (list_store[j], &iter[j], ICON_COLUMN , currencies[i], TITLE_COLUMN, tmp_string,-1);
        }

        column[j] = hildon_touch_selector_append_column (HILDON_TOUCH_SELECTOR (selector[j]), GTK_TREE_MODEL (list_store[j]), NULL, NULL);
        hildon_touch_selector_column_set_text_column(column[j], TITLE_COLUMN);

        renderer[j] = gtk_cell_renderer_pixbuf_new();
        gtk_cell_renderer_set_fixed_size (renderer[j], -1, 100);

        gtk_cell_layout_pack_start ( GTK_CELL_LAYOUT (column[j]), renderer[j], TRUE);
        gtk_cell_layout_set_attributes ( GTK_CELL_LAYOUT (column[j]), renderer[j], "stock-id", ICON_COLUMN, NULL);

        renderer[j] = gtk_cell_renderer_text_new();

        gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (column[j]), renderer[j], TRUE);
        gtk_cell_layout_set_attributes ( GTK_CELL_LAYOUT ( column[j]), renderer[j], "text", TITLE_COLUMN, NULL);




        /* Create buttons */
        button[j] = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);

        if ( j == 0 ) {
            hildon_button_set_title(HILDON_BUTTON(button[j]), "Reference currency:");
        } 
        else {
            char title[20];
            sprintf(title, "Target currency:", j);
            hildon_button_set_title(HILDON_BUTTON(button[j]), title);
        }

        gtk_button_set_alignment(GTK_BUTTON(button[j]), 0.0, 0.5);


        hildon_button_set_value_alignment(HILDON_BUTTON(button[j]), 0.0, 0.5);
        /*set selector */
        hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(button[j]), HILDON_TOUCH_SELECTOR(selector[j]));

        if ( j == 0 ) {
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[j]), desktop_plugin->curset->type - 1);
        }
        else {
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[j]), desktop_plugin->curset->active_currency->type - 1);
        }

        /* pack buttons */
        gtk_box_pack_start(GTK_BOX(pan_content), button[j], FALSE, FALSE, 0);

    } 

    /* Create button for update_interval */
    selector[4] = hildon_touch_selector_new_text();
    renderer[4] = gtk_cell_renderer_text_new();


    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR ( selector[4] ), "1 hour");
    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR ( selector[4] ), "2 hours");
    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR ( selector[4] ), "4 hours");
    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR ( selector[4] ), "8 hours");
    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR ( selector[4] ), "16 hours");
    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR ( selector[4] ), "24 hours");
    hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR ( selector[4] ), "Never");

    button[4] = hildon_picker_button_new (HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);

    gtk_button_set_alignment(GTK_BUTTON(button[4]), 0.0, 0.5);
    hildon_button_set_title (HILDON_BUTTON(button[4]), "Update interval:");
    hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(button[4]), HILDON_TOUCH_SELECTOR(selector[4]));

    switch (desktop_plugin->curset->update_interval) {
        case 1:
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[4]), 0);
            break;
        case 2:
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[4]), 1);
            break;
        case 4:
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[4]), 2);
            break;
        case 8:
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[4]), 3);
            break;
        case 16:
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[4]), 4);
            break;
        case 24:
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[4]), 5);
            break;
        case -1:
            hildon_picker_button_set_active(HILDON_PICKER_BUTTON(button[4]), 6);
            break;
    }

    gtk_box_pack_start(GTK_BOX(pan_content), button[4], FALSE, FALSE, 0);


    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(pan), pan_content);
    gtk_container_add(GTK_CONTAINER(content), pan); 


    /* Show */
    gtk_widget_show_all(dialog);

    while (TRUE ) {
        int result = gtk_dialog_run(GTK_DIALOG(dialog));
        // Get values and update gui
        if ( result == GTK_RESPONSE_ACCEPT) {

            for ( j = 0; j < 2; j++ ) {

                if ( j == 0 ) {
                    if ( desktop_plugin->curset->type != hildon_picker_button_get_active(HILDON_PICKER_BUTTON(button[j])) + 1 ) {
                        desktop_plugin->curset->type = hildon_picker_button_get_active(HILDON_PICKER_BUTTON(button[j])) + 1;
                        currency_changed = 1;
                    }
                }
                else {
                    if ( desktop_plugin->curset->active_currency->type != hildon_picker_button_get_active(HILDON_PICKER_BUTTON(button[j])) +1) {
                        desktop_plugin->curset->active_currency->type = hildon_picker_button_get_active(HILDON_PICKER_BUTTON(button[j])) + 1;
                        currency_changed = 1;
                    }
                }
            }

            switch ( hildon_picker_button_get_active(HILDON_PICKER_BUTTON(button[4]))) {
                case 0: 
                    if ( desktop_plugin->curset->update_interval != 1 ) {
                        desktop_plugin->curset->update_interval = 1;
                        g_source_remove(desktop_plugin->timeout);
                        desktop_plugin->timeout = g_timeout_add(TO_HOUR(desktop_plugin->curset->update_interval), update_values,desktop_plugin);
                    }
                    break;
                case 1:
                    if ( desktop_plugin->curset->update_interval != 2 ) {
                        desktop_plugin->curset->update_interval = 2;
                        g_source_remove(desktop_plugin->timeout);
                        desktop_plugin->timeout = g_timeout_add(TO_HOUR(desktop_plugin->curset->update_interval), update_values, desktop_plugin);
                    }
                    break;
                case 2:
                    if ( desktop_plugin->curset->update_interval != 4 ) {
                        desktop_plugin->curset->update_interval = 4;
                        g_source_remove(desktop_plugin->timeout);
                        desktop_plugin->timeout = g_timeout_add(TO_HOUR(desktop_plugin->curset->update_interval), update_values, desktop_plugin);
                    }
                    break;
                case 3:
                    if ( desktop_plugin->curset->update_interval != 8 ) {
                        desktop_plugin->curset->update_interval = 8;
                        g_source_remove(desktop_plugin->timeout);
                        desktop_plugin->timeout = g_timeout_add(TO_HOUR(desktop_plugin->curset->update_interval), update_values, desktop_plugin);
                    }
                    break;
                case 4:
                    if ( desktop_plugin->curset->update_interval != 16 ) {
                        desktop_plugin->curset->update_interval = 16;
                        g_source_remove(desktop_plugin->timeout);
                        desktop_plugin->timeout = g_timeout_add(TO_HOUR(desktop_plugin->curset->update_interval), update_values, desktop_plugin);
                    }
                    break;
                case 5:
                    if ( desktop_plugin->curset->update_interval != 24 ) {
                        desktop_plugin->curset->update_interval = 24;
                        g_source_remove(desktop_plugin->timeout);
                        desktop_plugin->timeout = g_timeout_add(TO_HOUR(desktop_plugin->curset->update_interval), update_values, desktop_plugin);
                    }
                    break;
                case 6:
                    if ( desktop_plugin->curset->update_interval != -1 ) {
                        desktop_plugin->curset->update_interval = -1;
                        g_source_remove(desktop_plugin->timeout);
                    }
                    break;
                default:
                    fprintf(stderr, "Default statement reached in switch, shouldn't happen! got %d\n", desktop_plugin->curset->update_interval);
                    exit(EXIT_FAILURE);
                    break;
            }


            // Get and update values and gui
            pthread_mutex_lock(&desktop_plugin->mutex);
            get_values_json(&desktop_plugin->curset);
            if ( desktop_plugin->curset->not_updated == 1 && currency_changed == 1) {
                strcpy(desktop_plugin->curset->active_currency->value, "offline");
            }
            save_config(&desktop_plugin);               
            update_ui(desktop_plugin);
            pthread_mutex_unlock(&desktop_plugin->mutex);

            gtk_widget_destroy(dialog);

            break;
        }
        else if ( result == GTK_RESPONSE_ABOUT ) {
            about_dialog();
        }
        else {

            gtk_widget_destroy(dialog);
            break;
        }
    } } 


gboolean update_values(CurrencyWidget *desktop_plugin) {
   
    pthread_mutex_lock(&desktop_plugin->mutex);
    
    get_values_json(&desktop_plugin->curset);
    update_ui(desktop_plugin);

    pthread_mutex_unlock(&desktop_plugin->mutex);

    return TRUE;
}


void about_dialog() {

    GtkWidget *dialog;
    GtkWidget *text_view;
    GtkTextBuffer *text_buffer;
    GtkWidget *label;
    GdkPixbuf *pixbuf;
    GtkTextMark *mark;
    GtkTextIter iter;
    GtkTextChildAnchor *anchor;
    GtkWidget *scroll_window;


    dialog = gtk_dialog_new();

    gtk_window_set_default_size(GTK_WINDOW(dialog), -1, 240);
    scroll_window = hildon_pannable_area_new();
    hildon_helper_set_thumb_scrollbar(GTK_SCROLLED_WINDOW(scroll_window), TRUE);
    gtk_widget_show(scroll_window);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), scroll_window, TRUE, TRUE, 0);

    gtk_window_set_title(GTK_WINDOW(dialog), "About");



    text_view = hildon_text_view_new();
    text_buffer = gtk_text_view_get_buffer ( GTK_TEXT_VIEW(text_view) );
    gtk_text_view_set_editable( GTK_TEXT_VIEW(text_view), FALSE);
    gtk_text_view_set_cursor_visible ( GTK_TEXT_VIEW(text_view), FALSE);
    mark = gtk_text_buffer_get_insert (GTK_TEXT_BUFFER(text_buffer));

    gtk_text_buffer_get_iter_at_mark (GTK_TEXT_BUFFER(text_buffer), &iter, mark);
    
    gtk_text_iter_set_line (&iter, 0);

    pixbuf = gdk_pixbuf_new_from_file(BINOP_ICON, NULL);
    gtk_text_buffer_insert_pixbuf (GTK_TEXT_BUFFER(text_buffer), &iter, pixbuf);

    char tmp_text[1000];
    sprintf(tmp_text, "\n\nCurrency Exchange Widget version 0.1.1\n\nCurrency Exchange Widget displays the current exchange rate\nof the selected currency.\n\nThis software is released under the GPL license.\n\nSource of exchange rate data: www.xurrency.com\nSource of flag icons: www.icondrawer.com\n\nwww.binop.com\n2010 %lc binop consulting group\n", 0xa9 );


    gtk_text_buffer_insert(text_buffer, &iter, tmp_text, -1);

    gtk_container_add(GTK_CONTAINER(scroll_window), text_view);
    gtk_widget_show_all(dialog);

    gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(dialog);
}


gboolean
connection_change( ConIcConnection *connection,   ConIcConnectionEvent *event, CurrencyWidget *desktop_plugin )
{
    ConIcConnectionStatus status = con_ic_connection_event_get_status(event);
    
    if ( status == CON_IC_STATUS_CONNECTED ) {
            pthread_mutex_lock(&desktop_plugin->mutex);
            get_values_json(&desktop_plugin->curset);
            if ( desktop_plugin->curset->not_updated == 1 ) {
                strcpy(desktop_plugin->curset->active_currency->value, "offline");
            }
            update_ui(desktop_plugin);
            pthread_mutex_unlock(&desktop_plugin->mutex);
    }
    
    return TRUE;
}
