#include "mainmenuscreen.h"
#include <QGraphicsScene>
#include <QPainter>
#include <QGraphicsPixmapItem>
#include <QCoreApplication>
#include "textbutton.h"
#include "roundrectbutton.h"

MainMenuScreen::MainMenuScreen(QGraphicsScene* scene)
    :AbscractScreen(scene)
{
    QGraphicsPixmapItem* title = new QGraphicsPixmapItem(QPixmap(":/image/game_title.png"),this,scene);
    title->setPos(800/2 - title->boundingRect().width()/2, 50 );

    RoundRectButton* newGameBtn = createRoundRectButton("New Game",20,300);
    connect(newGameBtn,SIGNAL(clicked()),this,SIGNAL(startNewGame()));
    newGameBtn->setPos(50,350);

    if(!QCoreApplication::arguments().contains("--livewallpaper")){  
        RoundRectButton* exitBtn  = createRoundRectButton("Exit",20,300);
        connect(exitBtn,SIGNAL(clicked()),this,SIGNAL(exitGame()));
        exitBtn->setPos(800 - 50 - 300,350);
    }else
        newGameBtn->setPos(250,350);

}

//void MainMenuScreen::paint ( QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/)
//{
////    QColor bgColor( Qt::darkGreen );
////    bgColor.setAlpha(200);
////    painter->fillRect(boundingRect(), bgColor);
//}
