#include "baseitem.h"
#include <QPainter>

BaseItem::BaseItem( Position position ): QGraphicsItem(0),mPosition(position)
{
    switch(position){
    case UpperLeft:
        setPos(0,150);
        break;
    case LowerLeft:
        setPos(0,280);
        break;
    case UpperRight:
        setPos(600,150);
        break;
    case LowerRight:
        setPos(600,280);
        break;
    }
}

void BaseItem::paint ( QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/ )
{
    painter->fillRect(x(),y(),200,5,Qt::red);
}

QRectF BaseItem::boundingRect() const
{
    return QRectF(0,0,200,5);
}

Position BaseItem::position()
{
    return mPosition;
}
